/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import com.github.yizzuide.milkomeda.ice.DelayBucket;
import com.github.yizzuide.milkomeda.ice.DelayJob;
import com.github.yizzuide.milkomeda.ice.IceContext;
import com.github.yizzuide.milkomeda.ice.IceProperties;
import com.github.yizzuide.milkomeda.ice.Job;
import com.github.yizzuide.milkomeda.ice.JobPool;
import com.github.yizzuide.milkomeda.ice.JobStatus;
import com.github.yizzuide.milkomeda.ice.ReadyQueue;
import com.github.yizzuide.milkomeda.universe.metadata.HandlerMetaData;
import com.github.yizzuide.milkomeda.universe.polyfill.RedisPolyfill;
import com.github.yizzuide.milkomeda.util.RedisUtil;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class DelayJobHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DelayJobHandler.class);
    private StringRedisTemplate redisTemplate;
    private JobPool jobPool;
    private DelayBucket delayBucket;
    private ReadyQueue readyQueue;
    private int index;
    private static final String KEY_IDEMPOTENT_LIMITER = "ice:execute_delay_bucket_lock_";
    @Autowired
    private IceProperties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean absent;
        String indexLockKey = null;
        if (this.props.isEnableJobTimerDistributed() && (absent = RedisUtil.setIfAbsent(indexLockKey = this.indexLockKey(), this.props.getTaskPopCountLockTimeoutSeconds().getSeconds(), (RedisTemplate<String, String>)this.redisTemplate).booleanValue())) {
            return;
        }
        DelayJob delayJob = null;
        try {
            delayJob = this.delayBucket.poll(this.index);
            if (delayJob == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (delayJob.getDelayTime() > currentTime) {
                return;
            }
            Job job = this.jobPool.get(delayJob.getJodId());
            if (job == null) {
                this.delayBucket.remove(this.index, delayJob);
                return;
            }
            JobStatus status = job.getStatus();
            if (JobStatus.RESERVED.equals((Object)status)) {
                this.processTtrJob(delayJob, job);
            } else {
                this.processDelayJob(delayJob, job);
            }
        }
        catch (Exception e) {
            log.error("Ice Timer\u5904\u7406\u5ef6\u8fdfJob {} \u5f02\u5e38\uff1a{}", new Object[]{delayJob != null ? delayJob.getJodId() : "[\u4efb\u52a1\u6570\u636e\u83b7\u53d6\u5931\u8d25]", e.getMessage(), e});
        }
        finally {
            if (this.props.isEnableJobTimerDistributed()) {
                RedisPolyfill.redisDelete((RedisTemplate)this.redisTemplate, indexLockKey);
            }
        }
    }

    private void processTtrJob(DelayJob delayJob, Job<?> job) {
        boolean overload;
        log.info("Ice\u5904\u7406TTR\u91cd\u8bd5\u7684Job {}\uff0c\u5df2\u91cd\u8bd5\u6b21\u6570\u4e3a{}", (Object)delayJob.getJodId(), (Object)delayJob.getRetryCount());
        boolean bl = overload = delayJob.getRetryCount() > job.getRetryCount();
        if (overload) {
            log.error("Ice\u68c0\u6d4b\u5230 Job {} \u7684TTR\u8d85\u65f6\u91cd\u8bd5\u8d85\u8fc7\u9884\u8bbe\u7684{}\u6b21\uff0c\u91cd\u8bd5\u6b21\u6570\u4e3a{}", new Object[]{job.getId(), job.getRetryCount(), delayJob.getRetryCount()});
            List<HandlerMetaData> handlerMetaDataList = IceContext.getTopicTtrOverloadMap().get(job.getTopic());
            if (handlerMetaDataList != null) {
                handlerMetaDataList.forEach(handlerMetaData -> {
                    Method method = handlerMetaData.getMethod();
                    try {
                        method.invoke(handlerMetaData.getTarget(), job);
                    }
                    catch (Exception e) {
                        log.error("Ice invoke TTR overload listener error: {}", (Object)e.getMessage(), (Object)e);
                    }
                });
            }
        }
        RedisUtil.batchOps(() -> {
            job.setStatus(JobStatus.DELAY);
            this.jobPool.push(job);
            this.delayBucket.remove(this.index, delayJob);
            if (delayJob.getRetryCount() < 0x7FFFFFFE) {
                delayJob.setRetryCount(delayJob.getRetryCount() + 1);
            }
            long delayDate = System.currentTimeMillis() + (this.props.isEnableDelayMultiRetryCount() ? job.getDelay() * (long)(delayJob.getRetryCount() + 1) * (long)this.props.getRetryDelayMultiFactor() : job.getDelay());
            delayJob.setDelayTime(delayDate);
            this.delayBucket.add(delayJob);
        }, (RedisTemplate<String, String>)this.redisTemplate);
    }

    private void processDelayJob(DelayJob delayJob, Job<?> job) {
        log.info("Ice\u6b63\u5728\u5904\u7406\u5ef6\u8fdf\u7684Job {}\uff0c\u5f53\u524d\u72b6\u6001\u4e3a\uff1a{}", (Object)delayJob.getJodId(), (Object)job.getStatus());
        RedisUtil.batchOps(() -> {
            job.setStatus(JobStatus.READY);
            this.jobPool.push(job);
            this.readyQueue.push(delayJob);
            this.delayBucket.remove(this.index, delayJob);
        }, (RedisTemplate<String, String>)this.redisTemplate);
    }

    private String indexLockKey() {
        String indexLockKey = KEY_IDEMPOTENT_LIMITER + this.index;
        indexLockKey = indexLockKey.intern();
        return indexLockKey;
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public JobPool getJobPool() {
        return this.jobPool;
    }

    public DelayBucket getDelayBucket() {
        return this.delayBucket;
    }

    public ReadyQueue getReadyQueue() {
        return this.readyQueue;
    }

    public int getIndex() {
        return this.index;
    }

    public IceProperties getProps() {
        return this.props;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setJobPool(JobPool jobPool) {
        this.jobPool = jobPool;
    }

    public void setDelayBucket(DelayBucket delayBucket) {
        this.delayBucket = delayBucket;
    }

    public void setReadyQueue(ReadyQueue readyQueue) {
        this.readyQueue = readyQueue;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setProps(IceProperties props) {
        this.props = props;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DelayJobHandler)) {
            return false;
        }
        DelayJobHandler other = (DelayJobHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringRedisTemplate this$redisTemplate = this.getRedisTemplate();
        StringRedisTemplate other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        JobPool this$jobPool = this.getJobPool();
        JobPool other$jobPool = other.getJobPool();
        if (this$jobPool == null ? other$jobPool != null : !this$jobPool.equals(other$jobPool)) {
            return false;
        }
        DelayBucket this$delayBucket = this.getDelayBucket();
        DelayBucket other$delayBucket = other.getDelayBucket();
        if (this$delayBucket == null ? other$delayBucket != null : !this$delayBucket.equals(other$delayBucket)) {
            return false;
        }
        ReadyQueue this$readyQueue = this.getReadyQueue();
        ReadyQueue other$readyQueue = other.getReadyQueue();
        if (this$readyQueue == null ? other$readyQueue != null : !this$readyQueue.equals(other$readyQueue)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        IceProperties this$props = this.getProps();
        IceProperties other$props = other.getProps();
        return !(this$props == null ? other$props != null : !((Object)this$props).equals(other$props));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DelayJobHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringRedisTemplate $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        JobPool $jobPool = this.getJobPool();
        result = result * 59 + ($jobPool == null ? 43 : $jobPool.hashCode());
        DelayBucket $delayBucket = this.getDelayBucket();
        result = result * 59 + ($delayBucket == null ? 43 : $delayBucket.hashCode());
        ReadyQueue $readyQueue = this.getReadyQueue();
        result = result * 59 + ($readyQueue == null ? 43 : $readyQueue.hashCode());
        result = result * 59 + this.getIndex();
        IceProperties $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        return result;
    }

    public String toString() {
        return "DelayJobHandler(redisTemplate=" + this.getRedisTemplate() + ", jobPool=" + this.getJobPool() + ", delayBucket=" + this.getDelayBucket() + ", readyQueue=" + this.getReadyQueue() + ", index=" + this.getIndex() + ", props=" + this.getProps() + ")";
    }

    public DelayJobHandler(StringRedisTemplate redisTemplate, JobPool jobPool, DelayBucket delayBucket, ReadyQueue readyQueue, int index, IceProperties props) {
        this.redisTemplate = redisTemplate;
        this.jobPool = jobPool;
        this.delayBucket = delayBucket;
        this.readyQueue = readyQueue;
        this.index = index;
        this.props = props;
    }
}

