/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import com.github.yizzuide.milkomeda.ice.DelayBucket;
import com.github.yizzuide.milkomeda.ice.Ice;
import com.github.yizzuide.milkomeda.ice.IceHolder;
import com.github.yizzuide.milkomeda.ice.IceProperties;
import com.github.yizzuide.milkomeda.ice.JobPool;
import com.github.yizzuide.milkomeda.ice.ReadyQueue;
import com.github.yizzuide.milkomeda.ice.RedisDelayBucket;
import com.github.yizzuide.milkomeda.ice.RedisIce;
import com.github.yizzuide.milkomeda.ice.RedisJobPool;
import com.github.yizzuide.milkomeda.ice.RedisReadyQueue;
import com.github.yizzuide.milkomeda.universe.config.MilkomedaContextConfig;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;

@Import(value={MilkomedaContextConfig.class})
@ConditionalOnClass(value={RedisTemplate.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={IceProperties.class})
public class IceBasicConfig {
    @Autowired
    private ApplicationContextHolder applicationContextHolder;

    @Bean
    @ConditionalOnMissingBean(value={JobPool.class})
    public JobPool jobPool() {
        return new RedisJobPool();
    }

    @Bean
    @ConditionalOnMissingBean(value={DelayBucket.class})
    public DelayBucket delayBucket() {
        return new RedisDelayBucket();
    }

    @Bean
    @ConditionalOnMissingBean(value={ReadyQueue.class})
    public ReadyQueue readyQueue() {
        return new RedisReadyQueue();
    }

    @Bean
    @ConditionalOnMissingBean(value={Ice.class})
    public Ice redisIce() {
        RedisIce redisIce = new RedisIce();
        IceHolder.setIce(redisIce);
        return redisIce;
    }
}

