/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import com.github.yizzuide.milkomeda.ice.IceHandler;
import com.github.yizzuide.milkomeda.ice.IceListener;
import com.github.yizzuide.milkomeda.ice.IceTtrOverloadListener;
import com.github.yizzuide.milkomeda.universe.context.AopContextHolder;
import com.github.yizzuide.milkomeda.universe.metadata.HandlerMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class IceContext
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(IceContext.class);
    private static Map<String, List<HandlerMetaData>> topicMap = new HashMap<String, List<HandlerMetaData>>();
    private static Map<String, List<HandlerMetaData>> topicTtrOverloadMap = new HashMap<String, List<HandlerMetaData>>();

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        topicMap = AopContextHolder.getHandlerMetaData(IceHandler.class, IceListener.class, (annotation, metaData) -> {
            IceListener iceListener = (IceListener)annotation;
            return iceListener.value();
        }, true);
        topicTtrOverloadMap = AopContextHolder.getHandlerMetaData(IceHandler.class, IceTtrOverloadListener.class, (annotation, metaData) -> {
            IceTtrOverloadListener iceTtrOverloadListener = (IceTtrOverloadListener)annotation;
            return iceTtrOverloadListener.value();
        }, true);
    }

    static Map<String, List<HandlerMetaData>> getTopicMap() {
        return topicMap;
    }

    static Map<String, List<HandlerMetaData>> getTopicTtrOverloadMap() {
        return topicTtrOverloadMap;
    }
}

