/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="milkomeda.ice")
class IceProperties {
    private boolean enableJobTimer = true;
    private boolean enableJobTimerDistributed = false;
    private int delayBucketCount = 3;
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration delayBucketPollRate = Duration.ofMillis(5000L);
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration ttr = Duration.ofMillis(30000L);
    private int retryCount = 3;
    private boolean enableDelayMultiRetryCount = true;
    private int retryDelayMultiFactor = 1;
    private boolean enableTask = false;
    private int taskPoolSize = 20;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration taskTerminationAwareSeconds = Duration.ofSeconds(60L);
    private int taskTopicPopMaxSize = 10;
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration taskExecuteRate = Duration.ofMillis(5000L);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration taskPopCountLockTimeoutSeconds = Duration.ofSeconds(60L);

    public boolean isEnableJobTimer() {
        return this.enableJobTimer;
    }

    public boolean isEnableJobTimerDistributed() {
        return this.enableJobTimerDistributed;
    }

    public int getDelayBucketCount() {
        return this.delayBucketCount;
    }

    public Duration getDelayBucketPollRate() {
        return this.delayBucketPollRate;
    }

    public Duration getTtr() {
        return this.ttr;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean isEnableDelayMultiRetryCount() {
        return this.enableDelayMultiRetryCount;
    }

    public int getRetryDelayMultiFactor() {
        return this.retryDelayMultiFactor;
    }

    public boolean isEnableTask() {
        return this.enableTask;
    }

    @Deprecated
    public int getTaskPoolSize() {
        return this.taskPoolSize;
    }

    @Deprecated
    public Duration getTaskTerminationAwareSeconds() {
        return this.taskTerminationAwareSeconds;
    }

    public int getTaskTopicPopMaxSize() {
        return this.taskTopicPopMaxSize;
    }

    public Duration getTaskExecuteRate() {
        return this.taskExecuteRate;
    }

    public Duration getTaskPopCountLockTimeoutSeconds() {
        return this.taskPopCountLockTimeoutSeconds;
    }

    public void setEnableJobTimer(boolean enableJobTimer) {
        this.enableJobTimer = enableJobTimer;
    }

    public void setEnableJobTimerDistributed(boolean enableJobTimerDistributed) {
        this.enableJobTimerDistributed = enableJobTimerDistributed;
    }

    public void setDelayBucketCount(int delayBucketCount) {
        this.delayBucketCount = delayBucketCount;
    }

    public void setDelayBucketPollRate(Duration delayBucketPollRate) {
        this.delayBucketPollRate = delayBucketPollRate;
    }

    public void setTtr(Duration ttr) {
        this.ttr = ttr;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setEnableDelayMultiRetryCount(boolean enableDelayMultiRetryCount) {
        this.enableDelayMultiRetryCount = enableDelayMultiRetryCount;
    }

    public void setRetryDelayMultiFactor(int retryDelayMultiFactor) {
        this.retryDelayMultiFactor = retryDelayMultiFactor;
    }

    public void setEnableTask(boolean enableTask) {
        this.enableTask = enableTask;
    }

    @Deprecated
    public void setTaskPoolSize(int taskPoolSize) {
        this.taskPoolSize = taskPoolSize;
    }

    @Deprecated
    public void setTaskTerminationAwareSeconds(Duration taskTerminationAwareSeconds) {
        this.taskTerminationAwareSeconds = taskTerminationAwareSeconds;
    }

    public void setTaskTopicPopMaxSize(int taskTopicPopMaxSize) {
        this.taskTopicPopMaxSize = taskTopicPopMaxSize;
    }

    public void setTaskExecuteRate(Duration taskExecuteRate) {
        this.taskExecuteRate = taskExecuteRate;
    }

    public void setTaskPopCountLockTimeoutSeconds(Duration taskPopCountLockTimeoutSeconds) {
        this.taskPopCountLockTimeoutSeconds = taskPopCountLockTimeoutSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IceProperties)) {
            return false;
        }
        IceProperties other = (IceProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableJobTimer() != other.isEnableJobTimer()) {
            return false;
        }
        if (this.isEnableJobTimerDistributed() != other.isEnableJobTimerDistributed()) {
            return false;
        }
        if (this.getDelayBucketCount() != other.getDelayBucketCount()) {
            return false;
        }
        Duration this$delayBucketPollRate = this.getDelayBucketPollRate();
        Duration other$delayBucketPollRate = other.getDelayBucketPollRate();
        if (this$delayBucketPollRate == null ? other$delayBucketPollRate != null : !((Object)this$delayBucketPollRate).equals(other$delayBucketPollRate)) {
            return false;
        }
        Duration this$ttr = this.getTtr();
        Duration other$ttr = other.getTtr();
        if (this$ttr == null ? other$ttr != null : !((Object)this$ttr).equals(other$ttr)) {
            return false;
        }
        if (this.getRetryCount() != other.getRetryCount()) {
            return false;
        }
        if (this.isEnableDelayMultiRetryCount() != other.isEnableDelayMultiRetryCount()) {
            return false;
        }
        if (this.getRetryDelayMultiFactor() != other.getRetryDelayMultiFactor()) {
            return false;
        }
        if (this.isEnableTask() != other.isEnableTask()) {
            return false;
        }
        if (this.getTaskPoolSize() != other.getTaskPoolSize()) {
            return false;
        }
        Duration this$taskTerminationAwareSeconds = this.getTaskTerminationAwareSeconds();
        Duration other$taskTerminationAwareSeconds = other.getTaskTerminationAwareSeconds();
        if (this$taskTerminationAwareSeconds == null ? other$taskTerminationAwareSeconds != null : !((Object)this$taskTerminationAwareSeconds).equals(other$taskTerminationAwareSeconds)) {
            return false;
        }
        if (this.getTaskTopicPopMaxSize() != other.getTaskTopicPopMaxSize()) {
            return false;
        }
        Duration this$taskExecuteRate = this.getTaskExecuteRate();
        Duration other$taskExecuteRate = other.getTaskExecuteRate();
        if (this$taskExecuteRate == null ? other$taskExecuteRate != null : !((Object)this$taskExecuteRate).equals(other$taskExecuteRate)) {
            return false;
        }
        Duration this$taskPopCountLockTimeoutSeconds = this.getTaskPopCountLockTimeoutSeconds();
        Duration other$taskPopCountLockTimeoutSeconds = other.getTaskPopCountLockTimeoutSeconds();
        return !(this$taskPopCountLockTimeoutSeconds == null ? other$taskPopCountLockTimeoutSeconds != null : !((Object)this$taskPopCountLockTimeoutSeconds).equals(other$taskPopCountLockTimeoutSeconds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IceProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableJobTimer() ? 79 : 97);
        result = result * 59 + (this.isEnableJobTimerDistributed() ? 79 : 97);
        result = result * 59 + this.getDelayBucketCount();
        Duration $delayBucketPollRate = this.getDelayBucketPollRate();
        result = result * 59 + ($delayBucketPollRate == null ? 43 : ((Object)$delayBucketPollRate).hashCode());
        Duration $ttr = this.getTtr();
        result = result * 59 + ($ttr == null ? 43 : ((Object)$ttr).hashCode());
        result = result * 59 + this.getRetryCount();
        result = result * 59 + (this.isEnableDelayMultiRetryCount() ? 79 : 97);
        result = result * 59 + this.getRetryDelayMultiFactor();
        result = result * 59 + (this.isEnableTask() ? 79 : 97);
        result = result * 59 + this.getTaskPoolSize();
        Duration $taskTerminationAwareSeconds = this.getTaskTerminationAwareSeconds();
        result = result * 59 + ($taskTerminationAwareSeconds == null ? 43 : ((Object)$taskTerminationAwareSeconds).hashCode());
        result = result * 59 + this.getTaskTopicPopMaxSize();
        Duration $taskExecuteRate = this.getTaskExecuteRate();
        result = result * 59 + ($taskExecuteRate == null ? 43 : ((Object)$taskExecuteRate).hashCode());
        Duration $taskPopCountLockTimeoutSeconds = this.getTaskPopCountLockTimeoutSeconds();
        result = result * 59 + ($taskPopCountLockTimeoutSeconds == null ? 43 : ((Object)$taskPopCountLockTimeoutSeconds).hashCode());
        return result;
    }

    public String toString() {
        return "IceProperties(enableJobTimer=" + this.isEnableJobTimer() + ", enableJobTimerDistributed=" + this.isEnableJobTimerDistributed() + ", delayBucketCount=" + this.getDelayBucketCount() + ", delayBucketPollRate=" + this.getDelayBucketPollRate() + ", ttr=" + this.getTtr() + ", retryCount=" + this.getRetryCount() + ", enableDelayMultiRetryCount=" + this.isEnableDelayMultiRetryCount() + ", retryDelayMultiFactor=" + this.getRetryDelayMultiFactor() + ", enableTask=" + this.isEnableTask() + ", taskPoolSize=" + this.getTaskPoolSize() + ", taskTerminationAwareSeconds=" + this.getTaskTerminationAwareSeconds() + ", taskTopicPopMaxSize=" + this.getTaskTopicPopMaxSize() + ", taskExecuteRate=" + this.getTaskExecuteRate() + ", taskPopCountLockTimeoutSeconds=" + this.getTaskPopCountLockTimeoutSeconds() + ")";
    }
}

