/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import com.github.yizzuide.milkomeda.ice.Ice;
import com.github.yizzuide.milkomeda.ice.IceContext;
import com.github.yizzuide.milkomeda.ice.IceProperties;
import com.github.yizzuide.milkomeda.ice.Job;
import com.github.yizzuide.milkomeda.universe.metadata.HandlerMetaData;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskSchedulingAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.CollectionUtils;

@Configuration
@AutoConfigureAfter(value={TaskSchedulingAutoConfiguration.class})
@ConditionalOnProperty(prefix="milkomeda.ice", name={"enable-task"}, havingValue="true")
public class IceScheduleConfig {
    private static final Logger log = LoggerFactory.getLogger(IceScheduleConfig.class);

    @Autowired
    public void config(Ice ice, IceProperties props, ThreadPoolTaskScheduler taskScheduler) {
        taskScheduler.scheduleAtFixedRate(() -> IceContext.getTopicMap().keySet().forEach(topic -> {
            List jobs = ice.pop((String)topic, props.getTaskTopicPopMaxSize());
            if (CollectionUtils.isEmpty(jobs)) {
                return;
            }
            boolean hasError = false;
            List<HandlerMetaData> metaDataList = IceContext.getTopicMap().get(topic);
            for (HandlerMetaData metaData : metaDataList) {
                try {
                    Method method = metaData.getMethod();
                    List jobList = jobs;
                    ReflectUtil.invokeWithWrapperInject(metaData.getTarget(), method, jobList, Job.class, Job::getBody, Job::setBody);
                }
                catch (Exception e) {
                    log.error("Ice schedule error: {}", (Object)e.getMessage(), (Object)e);
                    hasError = true;
                }
            }
            if (!hasError) {
                ice.finish(jobs);
            }
        }), props.getTaskExecuteRate());
    }
}

