/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import com.github.yizzuide.milkomeda.ice.DelayBucket;
import com.github.yizzuide.milkomeda.ice.DelayJob;
import com.github.yizzuide.milkomeda.ice.IceProperties;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.util.CollectionUtils;

public class RedisDelayBucket
implements DelayBucket,
InitializingBean {
    @Autowired
    private IceProperties props;
    private StringRedisTemplate redisTemplate;
    private List<String> bucketNames = new ArrayList<String>();
    private static AtomicInteger index = new AtomicInteger(0);
    public static final int DEFAULT_MAX_BUCKET_SIZE = 100;

    @Override
    public void add(DelayJob delayJob) {
        String bucketName = this.getCurrentBucketName();
        BoundZSetOperations<String, String> bucket = this.getBucket(bucketName);
        bucket.add((Object)JSONUtil.serialize(delayJob), (double)delayJob.getDelayTime());
    }

    @Override
    public void add(List<DelayJob> delayJobs) {
        String bucketName = this.getCurrentBucketName();
        BoundZSetOperations<String, String> bucket = this.getBucket(bucketName);
        Set delayJobSet = delayJobs.stream().map(delayJob -> new DefaultTypedTuple((Object)JSONUtil.serialize(delayJob), Double.valueOf(delayJob.getDelayTime()))).collect(Collectors.toSet());
        bucket.add(delayJobSet);
    }

    @Override
    public DelayJob poll(Integer index) {
        String name = this.bucketNames.get(index);
        BoundZSetOperations<String, String> bucket = this.getBucket(name);
        Set set = bucket.rangeWithScores(0L, 1L);
        if (CollectionUtils.isEmpty((Collection)set)) {
            return null;
        }
        ZSetOperations.TypedTuple typedTuple = set.toArray(new ZSetOperations.TypedTuple[0])[0];
        return JSONUtil.parse((String)typedTuple.getValue(), DelayJob.class);
    }

    @Override
    public void remove(Integer index, DelayJob delayJob) {
        String name = this.bucketNames.get(index);
        BoundZSetOperations<String, String> bucket = this.getBucket(name);
        bucket.remove(new Object[]{JSONUtil.serialize(delayJob)});
    }

    private BoundZSetOperations<String, String> getBucket(String bucketName) {
        return this.redisTemplate.boundZSetOps((Object)bucketName);
    }

    private String getCurrentBucketName() {
        int thisIndex = index.getAndIncrement() % 100;
        return this.bucketNames.get(thisIndex % this.props.getDelayBucketCount());
    }

    public void afterPropertiesSet() {
        this.redisTemplate = (StringRedisTemplate)ApplicationContextHolder.get().getBean(StringRedisTemplate.class);
        for (int i = 0; i < this.props.getDelayBucketCount(); ++i) {
            this.bucketNames.add("ice:bucket" + i);
        }
    }
}

