/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.yizzuide.milkomeda.ice.DelayBucket;
import com.github.yizzuide.milkomeda.ice.DelayJob;
import com.github.yizzuide.milkomeda.ice.Ice;
import com.github.yizzuide.milkomeda.ice.IceProperties;
import com.github.yizzuide.milkomeda.ice.Job;
import com.github.yizzuide.milkomeda.ice.JobPool;
import com.github.yizzuide.milkomeda.ice.JobStatus;
import com.github.yizzuide.milkomeda.ice.ReadyQueue;
import com.github.yizzuide.milkomeda.universe.polyfill.RedisPolyfill;
import com.github.yizzuide.milkomeda.util.RedisUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisIce
implements Ice {
    private static final Logger log = LoggerFactory.getLogger(RedisIce.class);
    @Autowired
    private JobPool jobPool;
    @Autowired
    private DelayBucket delayBucket;
    @Autowired
    private ReadyQueue readyQueue;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private IceProperties props;
    private static final String KEY_IDEMPOTENT_LIMITER = "ice:range_pop_lock";

    @Override
    public void add(Job job) {
        job.setId(job.getTopic() + "-" + job.getId());
        if (this.jobPool.exists(job.getId())) {
            return;
        }
        job.setStatus(JobStatus.DELAY);
        RedisUtil.batchOps(() -> {
            this.jobPool.push(job);
            this.delayBucket.add(new DelayJob(job));
        }, (RedisTemplate<String, String>)this.redisTemplate);
    }

    @Override
    public <T> void add(String id, String topic, T body, Duration delay) {
        this.add(id, topic, body, delay.toMillis());
    }

    @Override
    public <T> void add(String id, String topic, T body, long delay) {
        Job<T> job = new Job<T>(id, topic, delay, this.props.getTtr().toMillis(), this.props.getRetryCount(), body);
        this.add(job);
    }

    @Override
    public <T> Job<T> pop(String topic) {
        DelayJob delayJob = this.readyQueue.pop(topic);
        if (delayJob == null) {
            return null;
        }
        Job job = this.jobPool.getByType(delayJob.getJodId(), new TypeReference<Job<T>>(){});
        if (job == null) {
            job = this.pop(topic);
            return job;
        }
        Job mJob = job;
        RedisUtil.batchOps(() -> {
            mJob.setStatus(JobStatus.RESERVED);
            delayJob.setDelayTime(System.currentTimeMillis() + mJob.getTtr());
            this.jobPool.push(mJob);
            this.delayBucket.add(delayJob);
        }, (RedisTemplate<String, String>)this.redisTemplate);
        return mJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Job<T>> pop(String topic, int count) {
        List jobList;
        if (count < 1 || this.readyQueue.size(topic) == 0L) {
            return null;
        }
        if (count == 1) {
            return Collections.singletonList(this.pop(topic));
        }
        boolean absent = RedisUtil.setIfAbsent(KEY_IDEMPOTENT_LIMITER, this.props.getTaskPopCountLockTimeoutSeconds().getSeconds(), (RedisTemplate<String, String>)this.redisTemplate);
        if (absent) {
            return null;
        }
        try {
            List<DelayJob> delayJobList = this.readyQueue.pop(topic, count);
            if (CollectionUtils.isEmpty(delayJobList)) {
                List<Job<T>> list = null;
                return list;
            }
            List<String> jobIds = delayJobList.stream().map(DelayJob::getJodId).collect(Collectors.toList());
            jobList = this.jobPool.getByType(jobIds, new TypeReference<Job<T>>(){}, count);
            if (CollectionUtils.isEmpty(jobList)) {
                List list = jobList = this.pop(topic, count);
                return list;
            }
            List mJobList = jobList;
            RedisUtil.batchOps(() -> {
                for (int i = 0; i < mJobList.size(); ++i) {
                    Job mJob = (Job)mJobList.get(i);
                    mJob.setStatus(JobStatus.RESERVED);
                    DelayJob delayJob = (DelayJob)delayJobList.get(i);
                    delayJob.setDelayTime(System.currentTimeMillis() + mJob.getTtr());
                }
                this.jobPool.push(mJobList);
                this.delayBucket.add(delayJobList);
            }, (RedisTemplate<String, String>)this.redisTemplate);
        }
        finally {
            RedisPolyfill.redisDelete((RedisTemplate)this.redisTemplate, KEY_IDEMPOTENT_LIMITER);
        }
        return jobList;
    }

    @Override
    public <T> void finish(List<Job<T>> jobs) {
        this.delete(jobs);
    }

    @Override
    public void finish(Object ... jobIds) {
        this.delete(jobIds);
    }

    @Override
    public <T> void delete(List<Job<T>> jobs) {
        List<Object> jobIds = jobs.stream().map(Job::getId).collect(Collectors.toList());
        this.delete(jobIds.toArray(new Object[0]));
    }

    @Override
    public void delete(Object ... jobIds) {
        this.jobPool.remove(jobIds);
    }
}

