/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.yizzuide.milkomeda.ice.Job;
import com.github.yizzuide.milkomeda.ice.JobPool;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RedisJobPool
implements JobPool,
InitializingBean {
    private StringRedisTemplate redisTemplate;
    private static final String PREFIX_NAME = "ice:job_pool";

    private BoundHashOperations<String, String, String> getPool() {
        return this.redisTemplate.boundHashOps((Object)PREFIX_NAME);
    }

    @Override
    public void push(Job job) {
        this.getPool().put((Object)job.getId(), (Object)JSONUtil.serialize(job));
    }

    @Override
    public <T> void push(List<Job<T>> jobs) {
        this.getPool().putAll(jobs.stream().collect(Collectors.toMap(Job::getId, JSONUtil::serialize)));
    }

    @Override
    public boolean exists(String jobId) {
        String job = (String)this.getPool().get((Object)jobId);
        return !StringUtils.isEmpty((Object)job);
    }

    @Override
    public Job get(String jobId) {
        String job = (String)this.getPool().get((Object)jobId);
        if (null == job) {
            return null;
        }
        return JSONUtil.parse(job, Job.class);
    }

    @Override
    public <T> Job<T> getByType(String jobId, TypeReference<Job<T>> typeReference) {
        String job = (String)this.getPool().get((Object)jobId);
        if (null == job) {
            return null;
        }
        return JSONUtil.nativeRead(job, typeReference);
    }

    @Override
    public <T> List<Job<T>> getByType(List<String> jobIds, TypeReference<Job<T>> typeReference, int count) {
        List jobOrigList = this.getPool().multiGet(jobIds);
        if (CollectionUtils.isEmpty((Collection)jobOrigList)) {
            return null;
        }
        ArrayList<Job<T>> jobList = new ArrayList<Job<T>>();
        for (String job : jobOrigList) {
            if (null == job) continue;
            jobList.add(JSONUtil.nativeRead(job, typeReference));
        }
        return jobList;
    }

    @Override
    public List<Job<String>> getByStringType(List<String> jobIds, TypeReference<Job<String>> typeReference, int count) {
        return this.getByType(jobIds, typeReference, count);
    }

    @Override
    public void remove(Object ... jobIds) {
        this.getPool().delete(jobIds);
    }

    public void afterPropertiesSet() {
        this.redisTemplate = (StringRedisTemplate)ApplicationContextHolder.get().getBean(StringRedisTemplate.class);
    }
}

