/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.ice;

import com.github.yizzuide.milkomeda.ice.DelayJob;
import com.github.yizzuide.milkomeda.ice.ReadyQueue;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisReadyQueue
implements ReadyQueue,
InitializingBean {
    private static final String PREFIX_NAME = "ice:ready_queue";
    private StringRedisTemplate redisTemplate;

    @Override
    public void push(DelayJob delayJob) {
        BoundListOperations<String, String> listOperations = this.getQueue(delayJob.getTopic());
        listOperations.rightPush((Object)JSONUtil.serialize(delayJob));
    }

    @Override
    public DelayJob pop(String topic) {
        BoundListOperations<String, String> listOperations = this.getQueue(topic);
        String delayJob = (String)listOperations.leftPop();
        if (null == delayJob) {
            return null;
        }
        return JSONUtil.parse(delayJob, DelayJob.class);
    }

    @Override
    public List<DelayJob> pop(String topic, int count) {
        List delayJobOrigList = this.getQueue(topic).range(0L, (long)count);
        if (CollectionUtils.isEmpty((Collection)delayJobOrigList)) {
            return null;
        }
        this.getQueue(topic).trim((long)(count + 1), -1L);
        return delayJobOrigList.stream().map(delayJob -> JSONUtil.parse(delayJob, DelayJob.class)).collect(Collectors.toList());
    }

    @Override
    public long size(String topic) {
        Long size = this.getQueue(topic).size();
        return size == null ? 0L : size;
    }

    private BoundListOperations<String, String> getQueue(String topic) {
        return this.redisTemplate.boundListOps((Object)this.getKey(topic));
    }

    private String getKey(String topic) {
        return "ice:ready_queue:" + topic;
    }

    public void afterPropertiesSet() {
        this.redisTemplate = (StringRedisTemplate)ApplicationContextHolder.get().getBean(StringRedisTemplate.class);
    }
}

