/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.light;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.yizzuide.milkomeda.light.Cache;
import com.github.yizzuide.milkomeda.light.LightCache;
import com.github.yizzuide.milkomeda.light.Spot;
import com.github.yizzuide.milkomeda.universe.function.ThrowableFunction;
import com.github.yizzuide.milkomeda.util.TypeUtil;
import java.io.Serializable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHelper {
    private static final Logger log = LoggerFactory.getLogger(CacheHelper.class);

    public static void set(Cache cache, Serializable id) {
        cache.set(id);
    }

    public static void set(Cache cache, Spot<Serializable, ?> spot) {
        if (cache instanceof LightCache) {
            LightCache lightCache = (LightCache)cache;
            lightCache.getSuperCache().set(spot);
        }
    }

    public static <E> Spot<Serializable, E> get(Cache cache) {
        return cache.get();
    }

    public static void remove(Cache cache) {
        cache.remove();
    }

    @Deprecated
    public static <E> E get(Cache cache, Class<E> eClazz, Function<Serializable, String> keyGenerator, ThrowableFunction<String, E> dataGenerator) throws Throwable {
        return CacheHelper.get(cache, eClazz, null, keyGenerator, dataGenerator);
    }

    public static <E> E get(Cache cache, Class<E> eClazz, Serializable id, Function<Serializable, String> keyGenerator, ThrowableFunction<String, E> dataGenerator) throws Throwable {
        return CacheHelper.get(cache, TypeUtil.class2TypeRef(eClazz), id, keyGenerator, dataGenerator);
    }

    @Deprecated
    public static <E> E get(Cache cache, TypeReference<E> eTypeRef, Function<Serializable, String> keyGenerator, ThrowableFunction<String, E> dataGenerator) throws Throwable {
        return CacheHelper.get(cache, eTypeRef, null, keyGenerator, dataGenerator);
    }

    public static <E> E get(Cache cache, TypeReference<E> eTypeRef, Serializable id, Function<Serializable, String> keyGenerator, ThrowableFunction<String, E> dataGenerator) throws Throwable {
        E data;
        Spot<Serializable, E> fastSpot = null;
        if (cache instanceof LightCache) {
            LightCache lightCache = (LightCache)cache;
            if (!lightCache.getOnlyCacheL2().booleanValue()) {
                fastSpot = CacheHelper.get(cache);
                if (fastSpot != null) {
                    data = fastSpot.getData();
                    if (data != null) {
                        return data;
                    }
                } else {
                    CacheHelper.set(cache, id);
                    fastSpot = CacheHelper.get(cache);
                }
            } else {
                fastSpot = new Spot();
                fastSpot.setView(id);
            }
        }
        assert (fastSpot != null);
        String key = keyGenerator.apply((Serializable)fastSpot.getView());
        Spot<Serializable, E> spot = cache.get(key, new TypeReference<Serializable>(){}, eTypeRef);
        if (spot != null) {
            data = spot.getData();
            fastSpot.setData(data);
            return data;
        }
        data = dataGenerator.apply(fastSpot.getView().toString());
        fastSpot.setData(data);
        cache.set(key, fastSpot);
        return data;
    }

    public static void erase(Cache cache, Serializable id, Function<Serializable, String> keyGenerator) {
        cache.erase(keyGenerator.apply(id));
    }

    public static <E> E put(Cache cache, Serializable id, Function<Serializable, String> keyGenerator, ThrowableFunction<String, E> dataGenerator) throws Throwable {
        String key = keyGenerator.apply(id);
        E data = dataGenerator.apply(key);
        if (data == null) {
            throw new NullPointerException("The method return is null, it must be set not null for update cache");
        }
        Spot<Serializable, E> fastSpot = null;
        if (cache instanceof LightCache) {
            LightCache lightCache = (LightCache)cache;
            if (!lightCache.getOnlyCacheL2().booleanValue()) {
                fastSpot = CacheHelper.get(cache);
                if (fastSpot == null) {
                    CacheHelper.set(cache, id);
                    fastSpot = CacheHelper.get(cache);
                }
            } else {
                fastSpot = new Spot();
                fastSpot.setView(id);
            }
        }
        assert (fastSpot != null);
        fastSpot.setData(data);
        cache.set(key, fastSpot);
        return data;
    }
}

