/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.light;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.yizzuide.milkomeda.light.Cache;
import com.github.yizzuide.milkomeda.light.Discard;
import com.github.yizzuide.milkomeda.light.HotDiscard;
import com.github.yizzuide.milkomeda.light.LazyExpireDiscard;
import com.github.yizzuide.milkomeda.light.LightContext;
import com.github.yizzuide.milkomeda.light.LightDiscardStrategy;
import com.github.yizzuide.milkomeda.light.LightProperties;
import com.github.yizzuide.milkomeda.light.Spot;
import com.github.yizzuide.milkomeda.light.TimelineDiscard;
import com.github.yizzuide.milkomeda.pulsar.PulsarHolder;
import com.github.yizzuide.milkomeda.universe.polyfill.RedisPolyfill;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class LightCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(LightCache.class);
    private Integer l1MaxCount;
    private Float l1DiscardPercent;
    private Long l1Expire;
    private Boolean onlyCacheL1;
    private LightDiscardStrategy strategy;
    private Class<Discard> strategyClass;
    private Discard discardStrategy;
    private Long l2Expire;
    private Boolean onlyCacheL2;
    private LightContext superCache = new LightContext();
    private Map<String, Spot<Serializable, Object>> cacheMap = new ConcurrentSkipListMap<String, Spot<Serializable, Object>>();
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public void set(Serializable id) {
        if (null == id) {
            return;
        }
        if (this.cacheMap.size() == 0) {
            this.superCache.set(id);
            return;
        }
        Optional<Spot> viableSpot = this.cacheMap.values().stream().filter(spot -> ((Serializable)spot.getView()).equals(id)).findFirst();
        if (!viableSpot.isPresent()) {
            this.superCache.set(id);
            return;
        }
        Spot spot2 = viableSpot.get();
        boolean isAbandon = this.discardStrategy.ascend(spot2);
        if (isAbandon) {
            this.superCache.set(id);
            return;
        }
        this.superCache.set(spot2);
    }

    @Override
    public <E> Spot<Serializable, E> get() {
        return this.superCache.get();
    }

    @Override
    public void remove() {
        this.superCache.remove();
    }

    @Override
    public void set(String key, Spot<Serializable, ?> spot) {
        if (spot.getClass() == Spot.class) {
            spot = this.discardStrategy.deform(key, spot, this.l1Expire);
        }
        this.cache(key, spot);
    }

    private void cache(String key, Spot<Serializable, Object> spot) {
        boolean success = true;
        if (!this.onlyCacheL2.booleanValue()) {
            success = this.cacheL1(key, spot);
        }
        if (!this.onlyCacheL1.booleanValue() && success) {
            this.cacheL2(key, spot);
        }
    }

    private void cacheL2(String key, Spot<Serializable, Object> spot) {
        PulsarHolder.getPulsar().post(() -> {
            String json = JSONUtil.serialize(spot);
            if (this.l2Expire > 0L) {
                this.stringRedisTemplate.opsForValue().set((Object)key, (Object)json, this.l2Expire.longValue(), TimeUnit.SECONDS);
            } else {
                this.stringRedisTemplate.opsForValue().set((Object)key, (Object)json);
            }
        });
    }

    private boolean cacheL1(String key, Spot<Serializable, Object> spot) {
        boolean isAbandon;
        if (this.cacheMap.size() + 1 > this.l1MaxCount) {
            this.discardStrategy.discard(this.cacheMap, this.l1DiscardPercent.floatValue());
        }
        if (isAbandon = this.discardStrategy.ascend(spot)) {
            if (!this.onlyCacheL1.booleanValue()) {
                RedisPolyfill.redisDelete((RedisTemplate)this.stringRedisTemplate, key);
            }
            return false;
        }
        this.cacheMap.put(key, spot);
        return true;
    }

    @Override
    public <E> Spot<Serializable, E> get(String key) {
        return this.get(key, null);
    }

    @Override
    public <E> Spot<Serializable, E> get(String key, Class<Serializable> vClazz, Class<E> eClazz) {
        JavaType javaType = TypeFactory.defaultInstance().constructParametricType(this.discardStrategy.spotClazz(), new Class[]{vClazz, eClazz});
        return this.get(key, javaType);
    }

    @Override
    public <E> Spot<Serializable, E> get(String key, TypeReference<Serializable> vTypeRef, TypeReference<E> eTypeRef) {
        JavaType vType = TypeFactory.defaultInstance().constructType(vTypeRef);
        JavaType eType = TypeFactory.defaultInstance().constructType(eTypeRef);
        JavaType javaType = TypeFactory.defaultInstance().constructParametricType(this.discardStrategy.spotClazz(), new JavaType[]{vType, eType});
        return this.get(key, javaType);
    }

    private <E> Spot<Serializable, E> get(String key, JavaType javaType) {
        String json;
        Spot spot = null;
        if (!this.onlyCacheL2.booleanValue() && null != (spot = this.cacheMap.get(key))) {
            boolean isAbandon = this.discardStrategy.ascend(spot);
            if (isAbandon) {
                this.erase(key);
                return null;
            }
            return spot;
        }
        if (!this.onlyCacheL1.booleanValue() && null != (json = (String)this.stringRedisTemplate.opsForValue().get((Object)key))) {
            spot = null != javaType ? (Spot)JSONUtil.nativeRead(json, javaType) : (Spot)JSONUtil.parse(json, this.discardStrategy.spotClazz());
            if (!this.onlyCacheL2.booleanValue() && !this.cacheL1(key, spot)) {
                return null;
            }
        }
        return spot;
    }

    @Override
    public void erase(String key) {
        if (!this.onlyCacheL1.booleanValue()) {
            RedisPolyfill.redisDelete((RedisTemplate)this.stringRedisTemplate, key);
        }
        if (!this.onlyCacheL2.booleanValue()) {
            this.cacheMap.remove(key);
        }
    }

    public void setL1DiscardPercent(Float l1DiscardPercent) {
        this.l1DiscardPercent = Float.valueOf(Math.min(Math.max(l1DiscardPercent.floatValue(), 0.1f), 1.0f));
    }

    public void setStrategy(LightDiscardStrategy strategy) {
        this.strategy = strategy;
        if (strategy == null) {
            this.discardStrategy = new HotDiscard();
            return;
        }
        switch (strategy) {
            case DEFAULT: 
            case HOT: {
                this.discardStrategy = new HotDiscard();
                break;
            }
            case TIMELINE: {
                this.discardStrategy = new TimelineDiscard();
                break;
            }
            case LazyExpire: {
                this.discardStrategy = new LazyExpireDiscard();
                break;
            }
            case CUSTOM: {
                if (this.strategyClass == null) {
                    this.discardStrategy = new HotDiscard();
                    return;
                }
                try {
                    this.discardStrategy = this.strategyClass.newInstance();
                    break;
                }
                catch (Exception e) {
                    this.discardStrategy = new HotDiscard();
                    log.error("light create strategy class error with message:{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public void copyFrom(LightCache other) {
        this.setL1MaxCount(other.getL1MaxCount());
        this.setL1DiscardPercent(other.getL1DiscardPercent());
        this.setL1Expire(other.getL1Expire());
        this.setStrategy(other.getStrategy());
        this.setStrategyClass(other.getStrategyClass());
        this.setOnlyCacheL1(other.getOnlyCacheL1());
        this.setL2Expire(other.getL2Expire());
        this.setOnlyCacheL2(other.getOnlyCacheL2());
    }

    public void configFrom(LightProperties props) {
        this.setL1MaxCount(props.getL1MaxCount());
        this.setL1DiscardPercent(Float.valueOf(props.getL1DiscardPercent()));
        this.setL1Expire(props.getL1Expire().getSeconds());
        this.setStrategy(props.getStrategy());
        this.setStrategyClass(props.getStrategyClass());
        this.setOnlyCacheL1(props.isOnlyCacheL1());
        this.setL2Expire(props.getL2Expire().getSeconds());
        this.setOnlyCacheL2(props.isOnlyCacheL2());
    }

    public void setL1MaxCount(Integer l1MaxCount) {
        this.l1MaxCount = l1MaxCount;
    }

    public Integer getL1MaxCount() {
        return this.l1MaxCount;
    }

    public Float getL1DiscardPercent() {
        return this.l1DiscardPercent;
    }

    public void setL1Expire(Long l1Expire) {
        this.l1Expire = l1Expire;
    }

    public Long getL1Expire() {
        return this.l1Expire;
    }

    public void setOnlyCacheL1(Boolean onlyCacheL1) {
        this.onlyCacheL1 = onlyCacheL1;
    }

    public Boolean getOnlyCacheL1() {
        return this.onlyCacheL1;
    }

    public LightDiscardStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategyClass(Class<Discard> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public Class<Discard> getStrategyClass() {
        return this.strategyClass;
    }

    public void setL2Expire(Long l2Expire) {
        this.l2Expire = l2Expire;
    }

    public Long getL2Expire() {
        return this.l2Expire;
    }

    public void setOnlyCacheL2(Boolean onlyCacheL2) {
        this.onlyCacheL2 = onlyCacheL2;
    }

    public Boolean getOnlyCacheL2() {
        return this.onlyCacheL2;
    }

    public LightContext getSuperCache() {
        return this.superCache;
    }
}

