/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.light;

import com.github.yizzuide.milkomeda.light.Cache;
import com.github.yizzuide.milkomeda.light.CacheHelper;
import com.github.yizzuide.milkomeda.light.LightCache;
import com.github.yizzuide.milkomeda.light.LightCacheEvict;
import com.github.yizzuide.milkomeda.light.LightCachePut;
import com.github.yizzuide.milkomeda.light.LightCacheable;
import com.github.yizzuide.milkomeda.light.LightDiscardStrategy;
import com.github.yizzuide.milkomeda.light.LightProperties;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import com.github.yizzuide.milkomeda.universe.context.WebContext;
import com.github.yizzuide.milkomeda.universe.el.ELContext;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=98)
@Aspect
public class LightCacheAspect {
    public static final String DEFAULT_BEAN_NAME = "lightCache";
    @Autowired
    private LightProperties props;

    @Around(value="execution(@LightCacheable * *.*(..)) && @annotation(cacheable)")
    public Object cacheableAround(ProceedingJoinPoint joinPoint, LightCacheable cacheable) throws Throwable {
        return this.applyAround(joinPoint, cacheable, cacheable.condition(), cacheable.value(), cacheable.keyPrefix(), cacheable.key());
    }

    @Around(value="execution(@LightCacheEvict * *.*(..)) && @annotation(cacheEvict)")
    public Object cacheEvictAround(ProceedingJoinPoint joinPoint, LightCacheEvict cacheEvict) throws Throwable {
        return this.applyAround(joinPoint, cacheEvict, cacheEvict.condition(), cacheEvict.value(), cacheEvict.keyPrefix(), cacheEvict.key());
    }

    @Around(value="execution(@LightCachePut * *.*(..)) && @annotation(cachePut)")
    public Object cachePutAround(ProceedingJoinPoint joinPoint, LightCachePut cachePut) throws Throwable {
        return this.applyAround(joinPoint, cachePut, cachePut.condition(), cachePut.value(), cachePut.keyPrefix(), cachePut.key());
    }

    private Object applyAround(ProceedingJoinPoint joinPoint, Annotation annotation, String condition, String cacheBeanName, String prefix, String key) throws Throwable {
        LightCacheable cacheable;
        LightCache cache;
        if (!StringUtils.isEmpty((Object)condition) && !Boolean.parseBoolean(ELContext.getValue((JoinPoint)joinPoint, condition))) {
            return joinPoint.proceed();
        }
        if (StringUtils.isEmpty((Object)key)) {
            throw new IllegalArgumentException(String.format("You must set key before use %s.", annotation.annotationType().getSimpleName()));
        }
        cacheBeanName = ReflectUtil.extractValue((JoinPoint)joinPoint, cacheBeanName);
        String viewId = ReflectUtil.extractValue((JoinPoint)joinPoint, key);
        boolean customCacheFlag = false;
        if (ApplicationContextHolder.get().containsBean(cacheBeanName)) {
            cache = (LightCache)ApplicationContextHolder.get().getBean(cacheBeanName, LightCache.class);
            customCacheFlag = true;
        } else {
            cacheBeanName = this.innerCacheBeanName(cacheBeanName);
            cache = WebContext.registerBean((ConfigurableApplicationContext)ApplicationContextHolder.get(), cacheBeanName, LightCache.class, new Object[0]);
        }
        if (annotation.annotationType() == LightCacheable.class && cache.getL1MaxCount() == null && (cacheable = (LightCacheable)annotation).copyDefaultConfig() && !customCacheFlag) {
            LightCache defaultBean = (LightCache)ApplicationContextHolder.get().getBean(DEFAULT_BEAN_NAME, LightCache.class);
            cache.copyFrom(defaultBean);
            cache.setStrategy(cacheable.discardStrategy());
            cache.setOnlyCacheL1(cacheable.onlyCacheL1());
            cache.setOnlyCacheL2(cacheable.onlyCacheL2());
            if (cacheable.expire() != -1L) {
                if (cacheable.discardStrategy() == LightDiscardStrategy.LazyExpire) {
                    cache.setL1Expire(cacheable.expire());
                }
                cache.setL2Expire(cacheable.expire());
            }
        }
        if (this.props.getInstances().containsKey(this.originCacheBeanName(cacheBeanName))) {
            cache.configFrom(this.props.getInstances().get(this.originCacheBeanName(cacheBeanName)));
        }
        Function<Serializable, String> keyGenerator = id -> prefix + id;
        if (annotation.annotationType() == LightCacheEvict.class) {
            joinPoint.proceed();
            CacheHelper.erase(cache, (Serializable)((Object)viewId), keyGenerator);
            return null;
        }
        if (annotation.annotationType() == LightCachePut.class) {
            return CacheHelper.put(cache, (Serializable)((Object)viewId), keyGenerator, id -> joinPoint.proceed());
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        return CacheHelper.get((Cache)cache, signature.getReturnType(), (Serializable)((Object)viewId), keyGenerator, id -> joinPoint.proceed());
    }

    private String innerCacheBeanName(String cacheBeanName) {
        return "lightCache_" + cacheBeanName;
    }

    private String originCacheBeanName(String innerCacheBeanName) {
        String prefix = "lightCache_";
        if (innerCacheBeanName.startsWith(prefix)) {
            return innerCacheBeanName.substring(prefix.length());
        }
        return innerCacheBeanName;
    }
}

