/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.light;

import com.github.yizzuide.milkomeda.light.Cache;
import com.github.yizzuide.milkomeda.light.LightCache;
import com.github.yizzuide.milkomeda.light.LightCacheAspect;
import com.github.yizzuide.milkomeda.light.LightCacheClearFilter;
import com.github.yizzuide.milkomeda.light.LightProperties;
import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LightProperties.class})
public class LightConfig {
    @Autowired
    private LightProperties props;

    @Bean
    @ConditionalOnMissingBean
    public LightCacheAspect lightCacheAspect() {
        return new LightCacheAspect();
    }

    @Bean(value={"lightCache"})
    public Cache lightCache() {
        LightCache lightCache = new LightCache();
        lightCache.configFrom(this.props);
        return lightCache;
    }

    @Bean
    @ConditionalOnMissingBean
    public FilterRegistrationBean<LightCacheClearFilter> lightCacheClearFilter() {
        FilterRegistrationBean lightCacheClearFilter = new FilterRegistrationBean();
        lightCacheClearFilter.setFilter((Filter)new LightCacheClearFilter());
        lightCacheClearFilter.setName("lightCacheClearFilter");
        lightCacheClearFilter.setUrlPatterns(Collections.singleton("/*"));
        return lightCacheClearFilter;
    }
}

