/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.light;

import com.github.yizzuide.milkomeda.light.Discard;
import com.github.yizzuide.milkomeda.light.LightDiscardStrategy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(prefix="milkomeda.light")
public class LightProperties {
    private int l1MaxCount = 64;
    private float l1DiscardPercent = 0.1f;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration l1Expire = Duration.ofSeconds(-1L);
    private LightDiscardStrategy strategy = LightDiscardStrategy.HOT;
    private Class<Discard> strategyClass;
    private boolean onlyCacheL1 = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration l2Expire = Duration.ofSeconds(-1L);
    private boolean onlyCacheL2 = false;
    private Map<String, LightProperties> instances = new HashMap<String, LightProperties>();

    public int getL1MaxCount() {
        return this.l1MaxCount;
    }

    public float getL1DiscardPercent() {
        return this.l1DiscardPercent;
    }

    public Duration getL1Expire() {
        return this.l1Expire;
    }

    public LightDiscardStrategy getStrategy() {
        return this.strategy;
    }

    public Class<Discard> getStrategyClass() {
        return this.strategyClass;
    }

    public boolean isOnlyCacheL1() {
        return this.onlyCacheL1;
    }

    public Duration getL2Expire() {
        return this.l2Expire;
    }

    public boolean isOnlyCacheL2() {
        return this.onlyCacheL2;
    }

    public Map<String, LightProperties> getInstances() {
        return this.instances;
    }

    public void setL1MaxCount(int l1MaxCount) {
        this.l1MaxCount = l1MaxCount;
    }

    public void setL1DiscardPercent(float l1DiscardPercent) {
        this.l1DiscardPercent = l1DiscardPercent;
    }

    public void setL1Expire(Duration l1Expire) {
        this.l1Expire = l1Expire;
    }

    public void setStrategy(LightDiscardStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategyClass(Class<Discard> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setOnlyCacheL1(boolean onlyCacheL1) {
        this.onlyCacheL1 = onlyCacheL1;
    }

    public void setL2Expire(Duration l2Expire) {
        this.l2Expire = l2Expire;
    }

    public void setOnlyCacheL2(boolean onlyCacheL2) {
        this.onlyCacheL2 = onlyCacheL2;
    }

    public void setInstances(Map<String, LightProperties> instances) {
        this.instances = instances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LightProperties)) {
            return false;
        }
        LightProperties other = (LightProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getL1MaxCount() != other.getL1MaxCount()) {
            return false;
        }
        if (Float.compare(this.getL1DiscardPercent(), other.getL1DiscardPercent()) != 0) {
            return false;
        }
        Duration this$l1Expire = this.getL1Expire();
        Duration other$l1Expire = other.getL1Expire();
        if (this$l1Expire == null ? other$l1Expire != null : !((Object)this$l1Expire).equals(other$l1Expire)) {
            return false;
        }
        LightDiscardStrategy this$strategy = this.getStrategy();
        LightDiscardStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy)) {
            return false;
        }
        Class<Discard> this$strategyClass = this.getStrategyClass();
        Class<Discard> other$strategyClass = other.getStrategyClass();
        if (this$strategyClass == null ? other$strategyClass != null : !this$strategyClass.equals(other$strategyClass)) {
            return false;
        }
        if (this.isOnlyCacheL1() != other.isOnlyCacheL1()) {
            return false;
        }
        Duration this$l2Expire = this.getL2Expire();
        Duration other$l2Expire = other.getL2Expire();
        if (this$l2Expire == null ? other$l2Expire != null : !((Object)this$l2Expire).equals(other$l2Expire)) {
            return false;
        }
        if (this.isOnlyCacheL2() != other.isOnlyCacheL2()) {
            return false;
        }
        Map<String, LightProperties> this$instances = this.getInstances();
        Map<String, LightProperties> other$instances = other.getInstances();
        return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LightProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getL1MaxCount();
        result = result * 59 + Float.floatToIntBits(this.getL1DiscardPercent());
        Duration $l1Expire = this.getL1Expire();
        result = result * 59 + ($l1Expire == null ? 43 : ((Object)$l1Expire).hashCode());
        LightDiscardStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        Class<Discard> $strategyClass = this.getStrategyClass();
        result = result * 59 + ($strategyClass == null ? 43 : $strategyClass.hashCode());
        result = result * 59 + (this.isOnlyCacheL1() ? 79 : 97);
        Duration $l2Expire = this.getL2Expire();
        result = result * 59 + ($l2Expire == null ? 43 : ((Object)$l2Expire).hashCode());
        result = result * 59 + (this.isOnlyCacheL2() ? 79 : 97);
        Map<String, LightProperties> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        return result;
    }

    public String toString() {
        return "LightProperties(l1MaxCount=" + this.getL1MaxCount() + ", l1DiscardPercent=" + this.getL1DiscardPercent() + ", l1Expire=" + this.getL1Expire() + ", strategy=" + (Object)((Object)this.getStrategy()) + ", strategyClass=" + this.getStrategyClass() + ", onlyCacheL1=" + this.isOnlyCacheL1() + ", l2Expire=" + this.getL2Expire() + ", onlyCacheL2=" + this.isOnlyCacheL2() + ", instances=" + this.getInstances() + ")";
    }
}

