/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.light;

import com.github.yizzuide.milkomeda.light.Discard;
import com.github.yizzuide.milkomeda.light.SortSpot;
import com.github.yizzuide.milkomeda.light.Spot;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SortDiscard
implements Discard {
    private static final Logger log = LoggerFactory.getLogger(SortDiscard.class);

    @Override
    public Spot<Serializable, Object> deform(String key, Spot<Serializable, Object> spot, long expire) {
        SortSpot sortSpot = null;
        try {
            sortSpot = this.spotClazz().newInstance();
            sortSpot.setView(spot.getView());
            sortSpot.setData(spot.getData());
            sortSpot.setKey(key);
        }
        catch (Exception e) {
            log.error("SortDiscard:- \u521b\u5efa\u7c7b\u5b9e\u4f8b\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return sortSpot;
    }

    @Override
    public void discard(Map<String, Spot<Serializable, Object>> cacheMap, float l1DiscardPercent) {
        Comparator<? extends SortSpot<Serializable, Object>> comparator = this.comparator();
        if (comparator == null) {
            return;
        }
        List list = cacheMap.values().stream().map(spot -> (SortSpot)spot).sorted(comparator).collect(Collectors.toList());
        int discardCount = Math.round((float)list.size() * l1DiscardPercent);
        if (discardCount == 0) {
            return;
        }
        if (discardCount == list.size()) {
            --discardCount;
        }
        for (int i = 0; i <= discardCount; ++i) {
            String key = ((SortSpot)list.get(i)).getKey();
            cacheMap.remove(key);
        }
    }

    protected abstract Comparator<? extends SortSpot<Serializable, Object>> comparator();
}

