/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.moon;

import com.github.yizzuide.milkomeda.light.LightCachePut;
import com.github.yizzuide.milkomeda.light.LightCacheable;
import com.github.yizzuide.milkomeda.moon.LeftHandPointer;
import com.github.yizzuide.milkomeda.moon.MoonNode;
import com.github.yizzuide.milkomeda.moon.MoonStrategy;
import com.github.yizzuide.milkomeda.moon.PeriodicMoonStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Moon<T> {
    public static final String CACHE_NAME = "lightCacheMoon";
    private String cacheName = "lightCacheMoon";
    private MoonNode<T> header;
    private MoonNode<T> pointer;
    private MoonNode<T> next;
    private int len;
    private List<T> phaseNames;
    private MoonStrategy moonStrategy = new PeriodicMoonStrategy();

    @SafeVarargs
    public final void set(T ... phaseNames) {
        this.add(phaseNames);
    }

    @SafeVarargs
    public final void add(T ... phaseNames) {
        this.setPhaseNames(new ArrayList<T>(Arrays.asList(phaseNames)));
        this.setLen(phaseNames.length);
        for (int i = 0; i < this.getLen(); ++i) {
            if (i == 0) {
                this.setHeader(new MoonNode());
                this.getHeader().setData(phaseNames[i]);
                this.setNext(this.getHeader());
                continue;
            }
            MoonNode<T> moonNode = new MoonNode<T>();
            moonNode.setData(phaseNames[i]);
            this.getNext().setNext(moonNode);
            this.setNext(moonNode);
        }
        this.getNext().setNext(this.getHeader());
        this.setPointer(this.getHeader());
    }

    public T getCurrentPhase() {
        return this.getMoonStrategy().getCurrentPhase(this);
    }

    public static <T> T getPhase(String key, Moon<T> prototype) {
        LeftHandPointer leftHandPointer = prototype.getLeftHandPointer(key);
        Integer p = leftHandPointer.getCurrent();
        T phase = prototype.getMoonStrategy().getPhase(key, p, prototype);
        prototype.pluckLeftHandPointer(key, leftHandPointer);
        return phase;
    }

    @LightCachePut(value="#target.cacheName", keyPrefix="moon:lhp-", key="#key")
    protected LeftHandPointer pluckLeftHandPointer(String key, LeftHandPointer leftHandPointer) {
        return this.getMoonStrategy().pluck(this, leftHandPointer);
    }

    @LightCacheable(value="#target.cacheName", keyPrefix="moon:lhp-", key="#key", onlyCacheL2=true)
    protected LeftHandPointer getLeftHandPointer(String key) {
        return new LeftHandPointer();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public MoonNode<T> getHeader() {
        return this.header;
    }

    public MoonNode<T> getPointer() {
        return this.pointer;
    }

    public MoonNode<T> getNext() {
        return this.next;
    }

    public int getLen() {
        return this.len;
    }

    public List<T> getPhaseNames() {
        return this.phaseNames;
    }

    public MoonStrategy getMoonStrategy() {
        return this.moonStrategy;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setHeader(MoonNode<T> header) {
        this.header = header;
    }

    public void setPointer(MoonNode<T> pointer) {
        this.pointer = pointer;
    }

    public void setNext(MoonNode<T> next) {
        this.next = next;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setPhaseNames(List<T> phaseNames) {
        this.phaseNames = phaseNames;
    }

    public void setMoonStrategy(MoonStrategy moonStrategy) {
        this.moonStrategy = moonStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Moon)) {
            return false;
        }
        Moon other = (Moon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cacheName = this.getCacheName();
        String other$cacheName = other.getCacheName();
        if (this$cacheName == null ? other$cacheName != null : !this$cacheName.equals(other$cacheName)) {
            return false;
        }
        MoonNode<T> this$header = this.getHeader();
        MoonNode<T> other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        MoonNode<T> this$pointer = this.getPointer();
        MoonNode<T> other$pointer = other.getPointer();
        if (this$pointer == null ? other$pointer != null : !((Object)this$pointer).equals(other$pointer)) {
            return false;
        }
        MoonNode<T> this$next = this.getNext();
        MoonNode<T> other$next = other.getNext();
        if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        List<T> this$phaseNames = this.getPhaseNames();
        List<T> other$phaseNames = other.getPhaseNames();
        if (this$phaseNames == null ? other$phaseNames != null : !((Object)this$phaseNames).equals(other$phaseNames)) {
            return false;
        }
        MoonStrategy this$moonStrategy = this.getMoonStrategy();
        MoonStrategy other$moonStrategy = other.getMoonStrategy();
        return !(this$moonStrategy == null ? other$moonStrategy != null : !this$moonStrategy.equals(other$moonStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Moon;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cacheName = this.getCacheName();
        result = result * 59 + ($cacheName == null ? 43 : $cacheName.hashCode());
        MoonNode<T> $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        MoonNode<T> $pointer = this.getPointer();
        result = result * 59 + ($pointer == null ? 43 : ((Object)$pointer).hashCode());
        MoonNode<T> $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        result = result * 59 + this.getLen();
        List<T> $phaseNames = this.getPhaseNames();
        result = result * 59 + ($phaseNames == null ? 43 : ((Object)$phaseNames).hashCode());
        MoonStrategy $moonStrategy = this.getMoonStrategy();
        result = result * 59 + ($moonStrategy == null ? 43 : $moonStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "Moon(cacheName=" + this.getCacheName() + ", header=" + this.getHeader() + ", pointer=" + this.getPointer() + ", next=" + this.getNext() + ", len=" + this.getLen() + ", phaseNames=" + this.getPhaseNames() + ", moonStrategy=" + this.getMoonStrategy() + ")";
    }
}

