/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.moon;

import com.github.yizzuide.milkomeda.moon.Moon;
import com.github.yizzuide.milkomeda.moon.MoonProperties;
import com.github.yizzuide.milkomeda.moon.MoonStrategy;
import com.github.yizzuide.milkomeda.universe.context.WebContext;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={MoonProperties.class})
public class MoonConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MoonConfig.class);
    @Autowired
    private MoonProperties moonProperties;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        List<MoonProperties.Instance> instances = this.moonProperties.getInstances();
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        for (MoonProperties.Instance instance : instances) {
            String beanName = instance.getName();
            String cacheName = instance.getCacheName();
            Class<MoonStrategy> moonStrategyClazz = instance.getMoonStrategyClazz();
            Moon moon = WebContext.registerBean((ConfigurableApplicationContext)applicationContext, beanName, Moon.class, new Object[0]);
            moon.setCacheName(cacheName);
            if (moonStrategyClazz != null) {
                try {
                    MoonStrategy moonStrategy = moonStrategyClazz.newInstance();
                    moon.setMoonStrategy(moonStrategy);
                    if (!CollectionUtils.isEmpty(instance.getProps())) {
                        ReflectUtil.setField(moonStrategy, instance.getProps());
                    }
                }
                catch (Exception e) {
                    log.error("Moon invoke error with msg: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (CollectionUtils.isEmpty(instance.getPhases())) continue;
            moon.add(instance.getPhases().toArray(new Object[0]));
        }
    }
}

