/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.moon;

import com.github.yizzuide.milkomeda.moon.LeftHandPointer;
import com.github.yizzuide.milkomeda.moon.Moon;
import com.github.yizzuide.milkomeda.moon.MoonStrategy;

public class PercentMoonStrategy
implements MoonStrategy {
    public static final int DEFAULT_PERCENT = 100;
    private int percent = 100;

    @Override
    public <T> T getCurrentPhase(Moon<T> moon) {
        throw new UnsupportedOperationException("PercentMoonStrategy is not support run on standalone.");
    }

    @Override
    public <T> T getPhase(String key, Integer p, Moon<T> prototype) {
        Integer i = 0;
        while (i < prototype.getLen()) {
            T phaseName = prototype.getPhaseNames().get(i);
            if (!(phaseName instanceof Integer)) {
                throw new UnsupportedOperationException("Only support int data type.");
            }
            Integer phase = (Integer)phaseName;
            if (i != 0) {
                phase = phase + (Integer)prototype.getPhaseNames().get(i - 1);
            }
            if (p < phase) {
                return (T)i;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return null;
    }

    @Override
    public LeftHandPointer pluck(Moon<?> moon, LeftHandPointer leftHandPointer) {
        int p = leftHandPointer.getCurrent();
        p = (p + 1) % this.getPercent();
        leftHandPointer.setCurrent(p);
        return leftHandPointer;
    }

    public static Integer[] parse(String percentExpress) {
        String[] percentComps = percentExpress.split("/");
        int len = percentComps.length;
        if (len < 2) {
            throw new IllegalArgumentException("Percent express format is illegal: " + percentExpress);
        }
        Integer[] percentArray = new Integer[len];
        for (int i = 0; i < len; ++i) {
            percentArray[i] = Integer.valueOf(percentComps[i]);
        }
        return percentArray;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PercentMoonStrategy)) {
            return false;
        }
        PercentMoonStrategy other = (PercentMoonStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPercent() == other.getPercent();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PercentMoonStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPercent();
        return result;
    }

    public String toString() {
        return "PercentMoonStrategy(percent=" + this.getPercent() + ")";
    }
}

