/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.moon;

import com.github.yizzuide.milkomeda.moon.LeftHandPointer;
import com.github.yizzuide.milkomeda.moon.Moon;
import com.github.yizzuide.milkomeda.moon.MoonNode;
import com.github.yizzuide.milkomeda.moon.MoonStrategy;
import java.util.concurrent.locks.ReentrantLock;

public class PeriodicMoonStrategy
implements MoonStrategy {
    private ReentrantLock reentrantLock = new ReentrantLock(false);

    @Override
    public <T> T getCurrentPhase(Moon<T> moon) {
        this.reentrantLock.lock();
        T data = moon.getPointer().getData();
        moon.setPointer(moon.getPointer().getNext());
        this.reentrantLock.unlock();
        return data;
    }

    @Override
    public <T> T getPhase(String key, Integer p, Moon<T> prototype) {
        MoonNode<T> next = prototype.getHeader();
        if (p != 0) {
            for (int i = 0; i < p; ++i) {
                next = next.getNext();
            }
        }
        return next.getData();
    }

    @Override
    public LeftHandPointer pluck(Moon<?> moon, LeftHandPointer leftHandPointer) {
        int p = leftHandPointer.getCurrent();
        p = (p + 1) % moon.getLen();
        leftHandPointer.setCurrent(p);
        return leftHandPointer;
    }
}

