/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.neutron;

import com.github.yizzuide.milkomeda.neutron.NeutronHolder;
import java.text.ParseException;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.quartz.JobStoreType;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;

public class Neutron {
    private static final Logger log = LoggerFactory.getLogger(Neutron.class);
    private static String JOB_GROUP_NAME = "NEUTRON_JOB_GROUP_NAME";
    private static String TRIGGER_GROUP_NAME = "NEUTRON_TRIGGER_GROUP_NAME";

    public boolean verifyCron(String cron) {
        try {
            CronScheduleBuilder.cronSchedule((String)cron);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static JobDetail createJobDetail(String jobName, String group, Class<? extends Job> jobClass) {
        return Neutron.createJobDetail(jobName, group, jobClass, "");
    }

    public static JobDetail createJobDetail(String jobName, String group, Class<? extends Job> jobClass, String description) {
        return JobBuilder.newJob(jobClass).withIdentity(jobName, group).withDescription(description).storeDurably(NeutronHolder.getProps().getJobStoreType() == JobStoreType.JDBC).build();
    }

    public static CronTrigger createCronTrigger(String triggerName, String triggerGroup, String cronExpression) throws ParseException {
        CronTriggerFactoryBean factoryBean = new CronTriggerFactoryBean();
        factoryBean.setName(triggerName);
        factoryBean.setGroup(triggerGroup);
        factoryBean.setCronExpression(cronExpression);
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }

    public static void addJob(String jobName, Class<? extends Job> clazz, String cron) {
        try {
            Scheduler scheduler = NeutronHolder.getScheduler();
            JobDetail jobDetail = Neutron.createJobDetail(jobName, JOB_GROUP_NAME, clazz);
            CronTrigger trigger = Neutron.createCronTrigger(jobName, TRIGGER_GROUP_NAME, cron);
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (!scheduler.isShutdown()) {
                scheduler.start();
            }
        }
        catch (ParseException | SchedulerException e) {
            log.error(e.getMessage(), e);
        }
    }

    public static void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> clazz, String cron) {
        try {
            Scheduler scheduler = NeutronHolder.getScheduler();
            JobDetail jobDetail = Neutron.createJobDetail(jobName, jobGroupName, clazz);
            CronTrigger trigger = Neutron.createCronTrigger(jobName, TRIGGER_GROUP_NAME, cron);
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (ParseException | SchedulerException e) {
            log.error(e.getMessage(), e);
        }
    }

    public static void modifyJobTime(String jobName, String cron) {
        Neutron.modifyJobTime(jobName, JOB_GROUP_NAME, jobName, TRIGGER_GROUP_NAME, cron);
    }

    public static void modifyJobTime(String jobName, String jobGroupName, String triggerName, String triggerGroupName, String cron) {
        try {
            Scheduler scheduler = NeutronHolder.getScheduler();
            CronTrigger trigger = (CronTrigger)scheduler.getTrigger(new TriggerKey(triggerName, triggerGroupName));
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(cron)) {
                JobDetail jobDetail = scheduler.getJobDetail(new JobKey(jobName, jobGroupName));
                Class objJobClass = jobDetail.getJobClass();
                Neutron.removeJob(jobName);
                Neutron.addJob(jobName, objJobClass, cron);
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void removeJob(String jobName) {
        Neutron.removeJob(jobName, JOB_GROUP_NAME, jobName, TRIGGER_GROUP_NAME);
    }

    public static void removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            Scheduler scheduler = NeutronHolder.getScheduler();
            TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            scheduler.pauseTrigger(triggerKey);
            scheduler.unscheduleJob(triggerKey);
            scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void startJobNow(String jobName) {
        try {
            Scheduler scheduler = NeutronHolder.getScheduler();
            scheduler.triggerJob(new JobKey(jobName, JOB_GROUP_NAME));
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void startJobNow(String jobName, String jobGroupName) {
        try {
            Scheduler scheduler = NeutronHolder.getScheduler();
            scheduler.triggerJob(new JobKey(jobName, jobGroupName));
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void startJobs() {
        try {
            Scheduler scheduler = NeutronHolder.getScheduler();
            scheduler.start();
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void shutdownJobs() {
        try {
            Scheduler scheduler = NeutronHolder.getScheduler();
            if (!scheduler.isShutdown()) {
                scheduler.shutdown();
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

