/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.particle;

import com.github.yizzuide.milkomeda.particle.LimitHandler;
import com.github.yizzuide.milkomeda.particle.Particle;
import com.github.yizzuide.milkomeda.particle.Process;
import com.github.yizzuide.milkomeda.universe.polyfill.RedisPolyfill;
import com.github.yizzuide.milkomeda.util.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class IdempotentLimiter
extends LimitHandler {
    private static final Logger log = LoggerFactory.getLogger(IdempotentLimiter.class);
    private static final String POSTFIX = ":repeat";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R limit(String key, long expire, Process<R> process) throws Throwable {
        String decoratedKey = key + POSTFIX;
        StringRedisTemplate redisTemplate = this.getRedisTemplate();
        Boolean isAbsent = RedisUtil.setIfAbsent(decoratedKey, expire, (RedisTemplate<String, String>)redisTemplate);
        assert (isAbsent != null);
        Particle particle = new Particle(this.getClass(), isAbsent == false, isAbsent != false ? null : "1");
        try {
            if (!particle.isLimited() && null != this.getNext()) {
                R r = this.getNext().limit(key, expire, process);
                return r;
            }
            R r = process.apply(particle);
            return r;
        }
        finally {
            if (isAbsent.booleanValue()) {
                RedisPolyfill.redisDelete((RedisTemplate)redisTemplate, decoratedKey);
            }
        }
    }
}

