/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.particle;

import com.github.yizzuide.milkomeda.particle.Limit;
import com.github.yizzuide.milkomeda.particle.Limiter;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Aspect
@Order(value=88)
public class ParticleAspect {
    private static final Logger log = LoggerFactory.getLogger(ParticleAspect.class);

    @Pointcut(value="@annotation(com.github.yizzuide.milkomeda.particle.Limit)")
    public void particlePointCut() {
    }

    @Around(value="particlePointCut()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Limit limit = ReflectUtil.getAnnotation((JoinPoint)joinPoint, Limit.class);
        String beanName = limit.limiterBeanName();
        String prefix = limit.name();
        String key = limit.key();
        if (StringUtils.isEmpty((Object)key)) {
            throw new IllegalArgumentException("You must set key for use Limit.");
        }
        key = ReflectUtil.extractValue((JoinPoint)joinPoint, key);
        long expire = limit.expire();
        Limiter limiter = !StringUtils.isEmpty((Object)beanName) ? (Limiter)ApplicationContextHolder.get().getBean(beanName, Limiter.class) : (Limiter)ApplicationContextHolder.get().getBean(limit.limiterBeanClass());
        return limiter.limit(prefix + ":" + key, expire, particle -> joinPoint.proceed(ReflectUtil.injectParam((JoinPoint)joinPoint, particle, limit, true)));
    }
}

