/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.particle;

import com.github.yizzuide.milkomeda.particle.BarrierLimiter;
import com.github.yizzuide.milkomeda.particle.IdempotentLimiter;
import com.github.yizzuide.milkomeda.particle.LimitHandler;
import com.github.yizzuide.milkomeda.particle.ParticleAspect;
import com.github.yizzuide.milkomeda.particle.ParticleFilter;
import com.github.yizzuide.milkomeda.particle.ParticleProperties;
import com.github.yizzuide.milkomeda.universe.context.WebContext;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.DelegatingFilterProxy;

@Configuration
@ConditionalOnClass(value={RedisTemplate.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={ParticleProperties.class})
public class ParticleConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ParticleConfig.class);
    @Autowired
    private ParticleProperties particleProperties;
    private Map<String, LimitHandler> cacheHandlerBeans = new HashMap<String, LimitHandler>();

    @Bean
    public ParticleAspect particleAspect() {
        return new ParticleAspect();
    }

    @Bean
    public IdempotentLimiter idempotentLimiter() {
        return new IdempotentLimiter();
    }

    @Bean
    public ParticleFilter particleFilter() {
        return new ParticleFilter();
    }

    @Bean
    @ConditionalOnProperty(prefix="milkomeda.particle", name={"enable-filter"}, havingValue="true")
    public FilterRegistrationBean particleFilterRegistrationBean() {
        FilterRegistrationBean particleFilterRegistrationBean = new FilterRegistrationBean();
        particleFilterRegistrationBean.setFilter((Filter)new DelegatingFilterProxy("particleFilter"));
        particleFilterRegistrationBean.setName("particleFilter");
        particleFilterRegistrationBean.setUrlPatterns(Collections.singleton("/*"));
        particleFilterRegistrationBean.setOrder(-2147483647);
        return particleFilterRegistrationBean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        List<ParticleProperties.Limiter> limiters = this.particleProperties.getLimiters();
        ArrayList<ParticleProperties.Limiter> barrierLimiters = new ArrayList<ParticleProperties.Limiter>();
        for (ParticleProperties.Limiter limiter : limiters) {
            String limiterName = limiter.getName();
            LimitHandler limitHandler = WebContext.registerBean((ConfigurableApplicationContext)applicationContext, limiterName, limiter.getHandlerClazz(), new Object[0]);
            this.cacheHandlerBeans.put(limiterName, limitHandler);
            if (!CollectionUtils.isEmpty(limiter.getProps())) {
                ReflectUtil.setField(limitHandler, limiter.getProps());
            }
            limiter.setLimitHandler(limitHandler);
            if (limiter.getHandlerClazz() != BarrierLimiter.class) continue;
            barrierLimiters.add(limiter);
        }
        for (ParticleProperties.Limiter limiter : barrierLimiters) {
            BarrierLimiter barrierLimiter = (BarrierLimiter)limiter.getLimitHandler();
            List<String> chain = barrierLimiter.getChain();
            if (CollectionUtils.isEmpty(chain)) {
                log.warn("Particle add barrier limiter find chain is empty, make true add at least one limiter.");
                continue;
            }
            ArrayList<LimitHandler> handlers = new ArrayList<LimitHandler>();
            for (String name : chain) {
                handlers.add(this.cacheHandlerBeans.get(name));
            }
            barrierLimiter.addLimitHandlerList(handlers);
        }
    }
}

