/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.particle;

import com.github.yizzuide.milkomeda.particle.ParticleProperties;
import com.github.yizzuide.milkomeda.universe.parser.url.URLPathMatcher;
import com.github.yizzuide.milkomeda.universe.parser.url.URLPlaceholderParser;
import com.github.yizzuide.milkomeda.universe.parser.url.URLPlaceholderResolver;
import com.github.yizzuide.milkomeda.universe.parser.yml.YmlResponseOutput;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ParticleFilter
implements Filter {
    @Autowired
    private ParticleProperties particleProperties;
    @Autowired(required=false)
    @Qualifier(value="particleURLPlaceholderResolver")
    private URLPlaceholderResolver particleURLPlaceholderResolver;
    private URLPlaceholderParser urlPlaceholderParser;
    private boolean skip = false;

    @PostConstruct
    public void init() {
        List<ParticleProperties.Limiter> limiters = this.particleProperties.getLimiters();
        if (CollectionUtils.isEmpty(limiters)) {
            this.skip = true;
            return;
        }
        this.skip = limiters.stream().allMatch(limiter -> CollectionUtils.isEmpty(limiter.getUrls()));
        if (this.skip) {
            return;
        }
        this.urlPlaceholderParser = new URLPlaceholderParser();
        this.urlPlaceholderParser.setCustomURLPlaceholderResolver(this.particleURLPlaceholderResolver);
        for (ParticleProperties.Limiter limiter2 : limiters) {
            if (CollectionUtils.isEmpty(limiter2.getUrls()) || StringUtils.isEmpty((Object)limiter2.getKeyTpl())) continue;
            limiter2.setCacheKeys(this.urlPlaceholderParser.grabPlaceHolders(limiter2.getKeyTpl()));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.skip || !CollectionUtils.isEmpty(this.particleProperties.getExcludeUrls()) && URLPathMatcher.match(this.particleProperties.getExcludeUrls(), httpServletRequest.getRequestURI()) || !CollectionUtils.isEmpty(this.particleProperties.getIncludeUrls()) && !URLPathMatcher.match(this.particleProperties.getIncludeUrls(), httpServletRequest.getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        List urlLimiters = this.particleProperties.getLimiters().stream().filter(limiter -> !CollectionUtils.isEmpty(limiter.getUrls()) && URLPathMatcher.match(limiter.getUrls(), httpServletRequest.getRequestURI())).collect(Collectors.toList());
        for (ParticleProperties.Limiter limiter2 : urlLimiters) {
            String key = this.urlPlaceholderParser.parse(limiter2.getKeyTpl(), httpServletRequest, null, limiter2.getCacheKeys());
            Map returnData = limiter2.getLimitHandler().limit(key, limiter2.getKeyExpire().getSeconds(), particle -> {
                if (particle.isLimited()) {
                    HashMap<String, Object> result = new HashMap<String, Object>(9);
                    Map<String, Object> responseInfo = limiter2.getResponse();
                    if (responseInfo == null) {
                        responseInfo = this.particleProperties.getResponse();
                    }
                    if (responseInfo == null || responseInfo.get("status") == null) {
                        result.put("status", 416);
                        return result;
                    }
                    int status = Integer.parseInt(responseInfo.get("status").toString());
                    result.put("status", status);
                    YmlResponseOutput.output(responseInfo, result, null, null, false);
                    return result;
                }
                return null;
            });
            if (returnData == null) continue;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.setStatus(Integer.parseInt(returnData.get("status").toString()));
            returnData.remove("status");
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("application/json");
            PrintWriter writer = httpServletResponse.getWriter();
            writer.println(JSONUtil.serialize(returnData));
            writer.flush();
            return;
        }
        chain.doFilter(request, response);
    }
}

