/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.particle;

import com.github.yizzuide.milkomeda.particle.LimitHandler;
import com.github.yizzuide.milkomeda.particle.Particle;
import com.github.yizzuide.milkomeda.particle.Process;
import com.github.yizzuide.milkomeda.particle.TimesType;
import com.github.yizzuide.milkomeda.util.RedisUtil;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class TimesLimiter
extends LimitHandler {
    private TimesType timesType;
    private Long limitTimes;
    private static final String POSTFIX = ":times";

    public TimesLimiter() {
    }

    public TimesLimiter(TimesType timesType, Long limitTimes) {
        this.timesType = timesType;
        this.limitTimes = limitTimes;
    }

    public <R> R limit(String key, Process<R> process) throws Throwable {
        return this.limit(key, 0L, process);
    }

    @Override
    public <R> R limit(String key, long expire, Process<R> process) throws Throwable {
        Date date;
        String decoratedKey = key + POSTFIX;
        StringRedisTemplate redisTemplate = this.getRedisTemplate();
        switch (this.timesType) {
            case SEC: {
                date = DateTime.now().plusSeconds(1).toDate();
                break;
            }
            case MIN: {
                date = DateTime.now().plusMinutes(1).toDate();
                break;
            }
            case HOUR: {
                date = DateTime.now().plusHours(1).toDate();
                break;
            }
            case DAY: {
                date = DateTime.now().plusDays(1).toDate();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.timesType));
            }
        }
        long times = RedisUtil.incr(decoratedKey, 1L, date, (RedisTemplate)redisTemplate);
        boolean isOver = times > this.limitTimes;
        Particle particle = new Particle(this.getClass(), isOver, times);
        if (!particle.isLimited() && null != this.getNext()) {
            return this.getNext().limit(key, expire, process);
        }
        return process.apply(particle);
    }

    public TimesType getTimesType() {
        return this.timesType;
    }

    public void setTimesType(TimesType timesType) {
        this.timesType = timesType;
    }

    @Override
    public String toString() {
        return "TimesLimiter(timesType=" + (Object)((Object)this.getTimesType()) + ", limitTimes=" + this.getLimitTimes() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimesLimiter)) {
            return false;
        }
        TimesLimiter other = (TimesLimiter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimesType this$timesType = this.getTimesType();
        TimesType other$timesType = other.getTimesType();
        if (this$timesType == null ? other$timesType != null : !((Object)((Object)this$timesType)).equals((Object)other$timesType)) {
            return false;
        }
        Long this$limitTimes = this.getLimitTimes();
        Long other$limitTimes = other.getLimitTimes();
        return !(this$limitTimes == null ? other$limitTimes != null : !((Object)this$limitTimes).equals(other$limitTimes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimesLimiter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TimesType $timesType = this.getTimesType();
        result = result * 59 + ($timesType == null ? 43 : ((Object)((Object)$timesType)).hashCode());
        Long $limitTimes = this.getLimitTimes();
        result = result * 59 + ($limitTimes == null ? 43 : ((Object)$limitTimes).hashCode());
        return result;
    }

    public Long getLimitTimes() {
        return this.limitTimes;
    }

    public void setLimitTimes(Long limitTimes) {
        this.limitTimes = limitTimes;
    }
}

