/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.pillar;

import com.github.yizzuide.milkomeda.pillar.Pillar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PillarExecutor<P, R> {
    private Set<Pillar<P, R>> pillars = new HashSet<Pillar<P, R>>();

    public void execute(String type, P params, R result) {
        for (Pillar<P, R> pillar : this.getPillars(type)) {
            pillar.process(params, result);
        }
    }

    public List<? extends Pillar<P, R>> getPillars(String type) {
        if (StringUtils.isEmpty((Object)type)) {
            return null;
        }
        return this.pillars.stream().filter(processor -> type.equals(processor.supportType())).collect(Collectors.toList());
    }

    public Pillar<P, R> getPillar(String type) {
        List<Pillar<P, R>> pillars = this.getPillars(type);
        if (CollectionUtils.isEmpty(pillars)) {
            throw new IllegalArgumentException("type " + type + " not find");
        }
        return pillars.get(0);
    }

    public void addPillar(Pillar<P, R> pillar) {
        this.pillars.add(pillar);
    }

    public void addPillarList(List<? extends Pillar<P, R>> pillarList) {
        this.pillars.addAll(pillarList);
    }
}

