/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.pulsar;

import com.github.yizzuide.milkomeda.pulsar.PulsarDeferredResult;
import com.github.yizzuide.milkomeda.pulsar.PulsarFlow;
import com.github.yizzuide.milkomeda.pulsar.PulsarHolder;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import com.github.yizzuide.milkomeda.util.ThreadUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncTask;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;

@Aspect
@Order(value=66)
public class Pulsar {
    private static final Logger log = LoggerFactory.getLogger(Pulsar.class);
    private Map<String, PulsarDeferredResult> deferredResultMap = new ConcurrentHashMap<String, PulsarDeferredResult>(64);
    @Autowired
    private ThreadPoolTaskExecutor applicationTaskExecutor;
    private static final int DEFAULT_CAPACITY = 64;

    Pulsar() {
        PulsarHolder.setPulsar(this);
    }

    private void putDeferredResult(PulsarDeferredResult pulsarDeferredResult) {
        this.deferredResultMap.put(pulsarDeferredResult.getDeferredResultID(), pulsarDeferredResult);
    }

    PulsarDeferredResult getPulsarDeferredResult(String id) {
        return this.deferredResultMap.get(id);
    }

    public DeferredResult<Object> getDeferredResult(String id) {
        PulsarDeferredResult pulsarDeferredResult = this.getPulsarDeferredResult(id);
        return pulsarDeferredResult == null ? null : pulsarDeferredResult.getDeferredResult();
    }

    private void removeDeferredResult(String id) {
        this.deferredResultMap.remove(id);
    }

    @Around(value="@annotation(com.github.yizzuide.milkomeda.pulsar.PulsarFlow)")
    Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object returnObj;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String invokeMethodName = joinPoint.getSignature().getName();
        if (methodSignature.getReturnType() != Object.class) {
            throw new ClassCastException("You must set [Object] return type on method " + invokeMethodName);
        }
        PulsarFlow pulsarFlow = ReflectUtil.getAnnotation((JoinPoint)joinPoint, PulsarFlow.class);
        if (!pulsarFlow.useDeferredResult()) {
            return new WebAsyncTask((Callable)new WebAsyncTaskCallable(joinPoint));
        }
        DeferredResult deferredResult = new DeferredResult();
        PulsarDeferredResult pulsarDeferredResult = new PulsarDeferredResult();
        pulsarDeferredResult.setDeferredResult((DeferredResult<Object>)deferredResult);
        String id = pulsarFlow.id();
        String idValue = null;
        if (!StringUtils.isEmpty((Object)id)) {
            idValue = ReflectUtil.extractValue((JoinPoint)joinPoint, id);
            pulsarDeferredResult.setDeferredResultID(idValue);
            this.putDeferredResult(pulsarDeferredResult);
        }
        if (null != (returnObj = joinPoint.proceed(ReflectUtil.injectParam((JoinPoint)joinPoint, pulsarDeferredResult, pulsarFlow, StringUtils.isEmpty((Object)idValue)))) && !(returnObj instanceof DeferredResult)) {
            if (null != idValue) {
                this.removeDeferredResult(idValue);
            }
            return returnObj;
        }
        if (null == pulsarDeferredResult.getDeferredResultID()) {
            throw new IllegalArgumentException("You must invoke setDeferredResultID method of PulsarDeferredResult parameter on method " + invokeMethodName);
        }
        if (null == idValue) {
            this.putDeferredResult(pulsarDeferredResult);
        }
        deferredResult.onCompletion(() -> this.removeDeferredResult(pulsarDeferredResult.getDeferredResultID()));
        return deferredResult;
    }

    public void post(Runnable runnable) {
        this.applicationTaskExecutor.execute(runnable);
    }

    public void configure(AsyncSupportConfigurer configurer, long timeout) {
        this.configure(configurer, 5, 10, 200, 100, timeout);
    }

    public void configure(AsyncSupportConfigurer configurer, int corePoolSize, int maxPoolSize, int queueCapacity, int keepAliveSeconds, long timeout) {
        configurer.setDefaultTimeout(timeout);
        ThreadUtil.configTaskExecutor(this.applicationTaskExecutor, "pulsar-", corePoolSize, maxPoolSize, queueCapacity, keepAliveSeconds);
        configurer.setTaskExecutor((AsyncTaskExecutor)this.applicationTaskExecutor);
    }

    private static class WebAsyncTaskCallable
    implements Callable<Object> {
        private ProceedingJoinPoint joinPoint;

        WebAsyncTaskCallable(ProceedingJoinPoint joinPoint) {
            this.joinPoint = joinPoint;
        }

        @Override
        public Object call() throws Exception {
            log.debug("pulsar:- WebAsyncTask invoke method: {}", (Object)this.joinPoint.getSignature());
            try {
                return this.joinPoint.proceed();
            }
            catch (Throwable t) {
                log.error("pulsar:-  WebAsyncTask invoke error with message: {}", (Object)t.getMessage(), (Object)t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                return ResponseEntity.status((int)500).body((Object)t.getMessage());
            }
        }
    }
}

