/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.pulsar;

import com.github.yizzuide.milkomeda.pulsar.Pulsar;
import com.github.yizzuide.milkomeda.pulsar.PulsarDeferredResult;
import com.github.yizzuide.milkomeda.pulsar.PulsarRunner;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.springframework.web.context.request.async.DeferredResult;

public class PulsarHolder {
    private static Function<Throwable, Object> errorCallback;
    private static Pulsar pulsar;

    static void setErrorCallback(Function<Throwable, Object> errorCallback) {
        PulsarHolder.errorCallback = errorCallback;
    }

    static void setPulsar(Pulsar pulsar) {
        PulsarHolder.pulsar = pulsar;
    }

    public static Function<Throwable, Object> getErrorCallback() {
        return errorCallback;
    }

    public static Pulsar getPulsar() {
        return pulsar;
    }

    public static Object defer(Callable<Object> callable, Object identifier) {
        DeferredResult<Object> deferredResult;
        if (identifier instanceof String || identifier instanceof Integer || identifier instanceof Long) {
            deferredResult = pulsar.getDeferredResult(String.valueOf(identifier));
        } else if (identifier instanceof PulsarDeferredResult) {
            deferredResult = ((PulsarDeferredResult)identifier).getDeferredResult();
        } else {
            throw new IllegalArgumentException("identifier " + identifier + " is invalid.");
        }
        pulsar.post(new PulsarRunner(callable, deferredResult));
        return null;
    }
}

