/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.pulsar;

import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class RequestContextDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        RequestAttributes context;
        try {
            context = RequestContextHolder.currentRequestAttributes();
        }
        catch (Exception e) {
            return runnable;
        }
        RequestAttributes finalContext = context;
        return () -> {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)finalContext);
                runnable.run();
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
            }
        };
    }
}

