/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.context;

import com.github.yizzuide.milkomeda.comet.core.CometAspect;
import com.github.yizzuide.milkomeda.comet.core.CometInterceptor;
import com.github.yizzuide.milkomeda.comet.core.WebCometData;
import com.github.yizzuide.milkomeda.comet.core.XCometData;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import com.github.yizzuide.milkomeda.universe.el.ELContext;
import com.github.yizzuide.milkomeda.universe.metadata.HandlerMetaData;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AopContextHolder {
    public static <T> T self(Class<T> clazz) {
        return (T)AopContext.currentProxy();
    }

    public static WebCometData getWebCometData() {
        WebCometData webCometData = CometInterceptor.getWebCometData();
        if (webCometData == null) {
            return CometAspect.getCurrentWebCometData();
        }
        return webCometData;
    }

    public static XCometData getXCometData() {
        return CometAspect.getCurrentXCometData();
    }

    public static Map<String, List<HandlerMetaData>> getHandlerMetaData(Class<? extends Annotation> handlerAnnotationClazz, Class<? extends Annotation> executeAnnotationClazz, BiFunction<Annotation, HandlerMetaData, String> nameProvider, boolean onlyOneExecutorPerHandler) {
        HashMap<String, List<HandlerMetaData>> handlerMap = new HashMap<String, List<HandlerMetaData>>();
        Map beanMap = ApplicationContextHolder.get().getBeansWithAnnotation(handlerAnnotationClazz);
        block0: for (String key : beanMap.keySet()) {
            Method[] methods;
            Object target = beanMap.get(key);
            for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(AopUtils.isAopProxy(target) ? AopUtils.getTargetClass(target) : target.getClass())) {
                Annotation executeAnnotation = AnnotationUtils.findAnnotation((Method)method, executeAnnotationClazz);
                if (null == executeAnnotation) continue;
                HandlerMetaData metaData = new HandlerMetaData();
                String name = nameProvider.apply(executeAnnotation, metaData);
                if (name.startsWith("'") || name.startsWith("@") || name.startsWith("#") || name.startsWith("T(") || name.startsWith("args[")) {
                    name = ELContext.getValue(target, new Object[0], target.getClass(), method, name, String.class);
                }
                if (StringUtils.isEmpty((Object)name)) {
                    throw new IllegalArgumentException("Please specify the [value] of " + executeAnnotation + " !");
                }
                metaData.setName(name);
                metaData.setTarget(target);
                metaData.setMethod(method);
                if (handlerMap.containsKey(name)) {
                    ((List)handlerMap.get(name)).add(metaData);
                } else {
                    ArrayList<HandlerMetaData> list = new ArrayList<HandlerMetaData>();
                    list.add(metaData);
                    handlerMap.put(name, list);
                }
                if (onlyOneExecutorPerHandler) continue block0;
            }
        }
        return handlerMap;
    }
}

