/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.context;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UrlPathHelper;

public class WebContext {
    private static PathMatcher mvcPathMatcher;
    private static UrlPathHelper urlPathHelper;

    public static void setMvcPathMatcher(PathMatcher mvcPathMatcher) {
        WebContext.mvcPathMatcher = mvcPathMatcher;
    }

    public static PathMatcher getMvcPathMatcher() {
        return mvcPathMatcher;
    }

    public static void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        WebContext.urlPathHelper = urlPathHelper;
    }

    public static UrlPathHelper getUrlPathHelper() {
        return urlPathHelper;
    }

    public static ServletRequestAttributes getRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }

    public static HttpServletRequest getRequest() {
        return WebContext.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return WebContext.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return WebContext.getRequest().getSession();
    }

    public static <T> T registerBean(ConfigurableApplicationContext applicationContext, String name, Class<T> clazz, Object ... args) {
        if (applicationContext.containsBean(name)) {
            return (T)applicationContext.getBean(name, clazz);
        }
        BeanDefinition beanDefinition = WebContext.build(clazz, args);
        return WebContext.registerBean(applicationContext, name, clazz, beanDefinition);
    }

    public static BeanDefinition build(Class<?> clazz, Object ... args) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        for (Object arg : args) {
            beanDefinitionBuilder.addConstructorArgValue(arg);
        }
        return beanDefinitionBuilder.getRawBeanDefinition();
    }

    public static <T> T registerBean(ConfigurableApplicationContext applicationContext, String name, Class<T> clazz, BeanDefinition beanDefinition) {
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(name, beanDefinition);
        return (T)applicationContext.getBean(name, clazz);
    }
}

