/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.env;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class CollectionsPropertySource
extends PropertySource<Object> {
    private static final Logger log = LoggerFactory.getLogger(CollectionsPropertySource.class);
    public static final String COLLECTIONS_PROPERTY_SOURCE_NAME = "collections";
    public static final String COLLECTIONS_EMPTY_MAP = "{}";
    public static final String COLLECTIONS_EMPTY_LIST = "[]";
    private static final String PREFIX = "collections.";

    public CollectionsPropertySource(String name, Object source) {
        super(name, source);
    }

    public CollectionsPropertySource(String name) {
        super(name);
    }

    public CollectionsPropertySource() {
        super(COLLECTIONS_PROPERTY_SOURCE_NAME);
    }

    public Object getProperty(String name) {
        if (!name.startsWith(PREFIX)) {
            return null;
        }
        return this.getValue(name.substring(PREFIX.length()));
    }

    public Object getValue(String type) {
        if ("emptyMap".equals(type)) {
            return COLLECTIONS_EMPTY_MAP;
        }
        if ("emptyList".equals(type)) {
            return COLLECTIONS_EMPTY_LIST;
        }
        return null;
    }

    public static void addToEnvironment(ConfigurableEnvironment environment) {
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new CollectionsPropertySource());
        log.trace("CollectionsPropertySource add to Environment");
    }
}

