/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.env;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;

public class SourcesLogApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(SourcesLogApplicationListener.class);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (environment.getClass() == StandardEnvironment.class) {
            return;
        }
        boolean logEnable = (Boolean)Binder.get((Environment)environment).bind("milkomeda.show-log", Boolean.class).orElseGet(() -> false);
        log.info("milkomeda log is {}", (Object)(logEnable ? "enable" : "disable"));
        log.info("Load sources: {}", (Object)environment.getPropertySources());
    }

    public int getOrder() {
        return -2147483628;
    }
}

