/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.parser.url;

import com.github.yizzuide.milkomeda.comet.core.CometRequestWrapper;
import com.github.yizzuide.milkomeda.universe.parser.url.URLPlaceholderResolver;
import com.github.yizzuide.milkomeda.util.DataTypeConvertUtil;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import com.github.yizzuide.milkomeda.util.PlaceholderResolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class URLPlaceholderParser {
    private PlaceholderResolver paramsPlaceholderResolver;
    private static PlaceholderResolver headerPlaceholderResolver = PlaceholderResolver.getResolver("(", ")");
    private static List<String> ignorePlaceHolders = Arrays.asList("uri", "method", "params");
    private URLPlaceholderResolver customURLPlaceholderResolver;
    public static final String KEY_HEAD = "header";
    public static final String KEY_PARAMS = "params";

    public URLPlaceholderParser() {
        this("{", "}");
    }

    public URLPlaceholderParser(String paramsPrefix, String paramsSuffix) {
        this.paramsPlaceholderResolver = PlaceholderResolver.getResolver(paramsPrefix, paramsSuffix);
    }

    public Map<String, List<String>> grabPlaceHolders(String tpl) {
        HashMap<String, List<String>> keyMap = new HashMap<String, List<String>>(4);
        keyMap.put(KEY_HEAD, headerPlaceholderResolver.getPlaceHolders(tpl));
        keyMap.put(KEY_PARAMS, this.paramsPlaceholderResolver.getPlaceHolders(tpl));
        return keyMap;
    }

    public String parse(String tpl, HttpServletRequest request, String params, Map<String, List<String>> placeHolders) {
        if (params == null) {
            params = CometRequestWrapper.resolveRequestParams(request, true);
        }
        HashMap<String, Object> placeholderResultMap = new HashMap<String, Object>();
        placeholderResultMap.put("uri", request.getRequestURI());
        placeholderResultMap.put("method", request.getMethod());
        placeholderResultMap.put(KEY_PARAMS, params);
        Map<String, Object> paramsMap = null;
        if (StringUtils.isNotEmpty((CharSequence)params)) {
            paramsMap = JSONUtil.parseMap(params, String.class, Object.class);
        }
        for (String placeHolder : placeHolders.get(KEY_PARAMS)) {
            String paramValue;
            if (ignorePlaceHolders.contains(placeHolder)) continue;
            String string = paramValue = paramsMap == null ? request.getParameter(placeHolder) : DataTypeConvertUtil.extractPath(placeHolder, paramsMap, "");
            placeholderResultMap.put(placeHolder, paramValue == null ? (this.customURLPlaceholderResolver == null ? "" : String.valueOf(this.customURLPlaceholderResolver.resolver(placeHolder, request))) : paramValue);
        }
        if (CollectionUtils.isEmpty((Collection)placeHolders.get(KEY_HEAD))) {
            return this.paramsPlaceholderResolver.resolveByMap(tpl, placeholderResultMap);
        }
        Iterator<String> iterator = placeHolders.get(KEY_HEAD).iterator();
        while (iterator.hasNext()) {
            String placeHolder;
            String headerValue = request.getHeader(placeHolder = iterator.next());
            placeholderResultMap.put(placeHolder, headerValue == null ? (this.customURLPlaceholderResolver == null ? "" : String.valueOf(this.customURLPlaceholderResolver.resolver(placeHolder, request))) : headerValue);
        }
        return headerPlaceholderResolver.resolveByMap(this.paramsPlaceholderResolver.resolveByMap(tpl, placeholderResultMap), placeholderResultMap);
    }

    public PlaceholderResolver getParamsPlaceholderResolver() {
        return this.paramsPlaceholderResolver;
    }

    public URLPlaceholderResolver getCustomURLPlaceholderResolver() {
        return this.customURLPlaceholderResolver;
    }

    public void setParamsPlaceholderResolver(PlaceholderResolver paramsPlaceholderResolver) {
        this.paramsPlaceholderResolver = paramsPlaceholderResolver;
    }

    public void setCustomURLPlaceholderResolver(URLPlaceholderResolver customURLPlaceholderResolver) {
        this.customURLPlaceholderResolver = customURLPlaceholderResolver;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URLPlaceholderParser)) {
            return false;
        }
        URLPlaceholderParser other = (URLPlaceholderParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlaceholderResolver this$paramsPlaceholderResolver = this.getParamsPlaceholderResolver();
        PlaceholderResolver other$paramsPlaceholderResolver = other.getParamsPlaceholderResolver();
        if (this$paramsPlaceholderResolver == null ? other$paramsPlaceholderResolver != null : !this$paramsPlaceholderResolver.equals(other$paramsPlaceholderResolver)) {
            return false;
        }
        URLPlaceholderResolver this$customURLPlaceholderResolver = this.getCustomURLPlaceholderResolver();
        URLPlaceholderResolver other$customURLPlaceholderResolver = other.getCustomURLPlaceholderResolver();
        return !(this$customURLPlaceholderResolver == null ? other$customURLPlaceholderResolver != null : !this$customURLPlaceholderResolver.equals(other$customURLPlaceholderResolver));
    }

    protected boolean canEqual(Object other) {
        return other instanceof URLPlaceholderParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlaceholderResolver $paramsPlaceholderResolver = this.getParamsPlaceholderResolver();
        result = result * 59 + ($paramsPlaceholderResolver == null ? 43 : $paramsPlaceholderResolver.hashCode());
        URLPlaceholderResolver $customURLPlaceholderResolver = this.getCustomURLPlaceholderResolver();
        result = result * 59 + ($customURLPlaceholderResolver == null ? 43 : $customURLPlaceholderResolver.hashCode());
        return result;
    }

    public String toString() {
        return "URLPlaceholderParser(paramsPlaceholderResolver=" + this.getParamsPlaceholderResolver() + ", customURLPlaceholderResolver=" + this.getCustomURLPlaceholderResolver() + ")";
    }
}

