/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.parser.yml;

import com.github.yizzuide.milkomeda.universe.parser.yml.YmlAliasNode;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class YmlParser {
    public static Map<String, YmlAliasNode> parseAliasMap(Map<String, Object> nodeMap) {
        HashMap<String, YmlAliasNode> aliasNodeMap = new HashMap<String, YmlAliasNode>();
        for (Map.Entry<String, Object> node : nodeMap.entrySet()) {
            String key = node.getKey();
            Object value = node.getValue();
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                key = String.valueOf(valueMap.keySet().toArray()[0]);
                value = valueMap.get(key);
            }
            YmlAliasNode ymlAliasNode = new YmlAliasNode();
            ymlAliasNode.setKey(key);
            ymlAliasNode.setValue(value);
            aliasNodeMap.put(node.getKey(), ymlAliasNode);
        }
        return aliasNodeMap;
    }

    public static Map<String, YmlAliasNode> parseAliasNodePath(Map<String, Object> nodeMap, String ... ownerAliasKeys) {
        return YmlParser.parseAliasNodePath(nodeMap, null, ownerAliasKeys);
    }

    public static Map<String, YmlAliasNode> parseAliasNodePath(Map<String, Object> nodeMap, Object replaceData, String ... ownerAliasKeys) {
        HashMap<String, YmlAliasNode> aliasNodeMap = new HashMap<String, YmlAliasNode>();
        for (String ownerAliasKey : ownerAliasKeys) {
            YmlParser.parseAliasNodePath(nodeMap, aliasNodeMap, ownerAliasKey, null, replaceData);
        }
        return aliasNodeMap;
    }

    public static void parseAliasMapPath(Map<String, Object> nodeMap, Map<String, Object> result, String ownerAliasKey, Object defaultValue, Object replaceData) {
        HashMap<String, YmlAliasNode> aliasNodeMap = new HashMap<String, YmlAliasNode>(2);
        YmlParser.parseAliasNodePath(nodeMap, aliasNodeMap, ownerAliasKey, defaultValue, replaceData);
        if (aliasNodeMap.isEmpty()) {
            return;
        }
        YmlAliasNode ymlAliasNode = (YmlAliasNode)aliasNodeMap.get(ownerAliasKey);
        result.put(ymlAliasNode.getKey(), ymlAliasNode.getValue());
    }

    public static void parseAliasNodePath(Map<String, Object> nodeMap, Map<String, YmlAliasNode> aliasNodeMap, String ownerAliasKey, Object defaultValue, Object replaceData) {
        String key = ownerAliasKey;
        Object value = nodeMap.get(ownerAliasKey);
        if (value == null && defaultValue != null) {
            value = defaultValue;
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            key = String.valueOf(valueMap.keySet().toArray()[0]);
            value = valueMap.get(key);
        }
        if (value == null) {
            return;
        }
        YmlAliasNode ymlAliasNode = new YmlAliasNode();
        ymlAliasNode.setKey(key);
        ymlAliasNode.setValue(value);
        if (replaceData instanceof Map) {
            Map replaceMap = (Map)replaceData;
            ymlAliasNode.setValue(replaceMap.get(ymlAliasNode.getKey()));
            aliasNodeMap.put(ownerAliasKey, ymlAliasNode);
            return;
        }
        if (StringUtils.isEmpty((Object)value) && replaceData != null) {
            ymlAliasNode.setValue(replaceData);
        }
        aliasNodeMap.put(ownerAliasKey, ymlAliasNode);
    }
}

