/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.parser.yml;

import com.github.yizzuide.milkomeda.universe.parser.yml.YmlParser;
import com.github.yizzuide.milkomeda.util.DataTypeConvertUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public class YmlResponseOutput {
    public static final String STATUS = "status";
    public static final String CODE = "code";
    public static final String MESSAGE = "message";
    public static final String ADDITION = "addition";
    public static final String CUSTOMS = "customs";
    public static final String CLAZZ = "clazz";
    public static final String ERROR_STACK_MSG = "error-stack-msg";
    public static final String ERROR_STACK = "error-stack";

    public static void output(@NonNull Map<String, Object> nodeMap, @NonNull Map<String, Object> result, Map<String, Object> defValMap, @Nullable Exception e, boolean customException) {
        Object addition;
        if (nodeMap == null) {
            throw new NullPointerException("nodeMap is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        if (e != null && customException) {
            Map<String, Object> exMap = DataTypeConvertUtil.beanToMap(e);
            YmlParser.parseAliasMapPath(nodeMap, result, CODE, null, exMap);
            YmlParser.parseAliasMapPath(nodeMap, result, MESSAGE, null, exMap);
            nodeMap.keySet().stream().filter(k -> !Arrays.asList(CLAZZ, STATUS, CODE, MESSAGE, ADDITION).contains(k) && !result.containsKey(k)).forEach(k -> YmlParser.parseAliasMapPath(nodeMap, result, k, null, exMap));
        } else {
            YmlParser.parseAliasMapPath(nodeMap, result, CODE, defValMap == null ? Integer.valueOf(-1) : defValMap.get(CODE), null);
            YmlParser.parseAliasMapPath(nodeMap, result, MESSAGE, defValMap == null ? "\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01" : defValMap.get(MESSAGE), null);
        }
        if (e != null && !customException) {
            YmlParser.parseAliasMapPath(nodeMap, result, ERROR_STACK_MSG, null, e.getMessage());
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace.length > 0) {
                String errorStack = String.format("exception happened: %s \n invoke root: %s", stackTrace[0], stackTrace[stackTrace.length - 1]);
                YmlParser.parseAliasMapPath(nodeMap, result, ERROR_STACK, null, errorStack);
            }
        }
        if ((addition = nodeMap.get(ADDITION)) instanceof Map) {
            Map additionMap = (Map)addition;
            for (String key : additionMap.keySet()) {
                Object ele = additionMap.get(key);
                if ("{}".equals(ele)) {
                    additionMap.put(key, Collections.emptyMap());
                    continue;
                }
                if (!"[]".equals(ele)) continue;
                additionMap.put(key, Collections.emptyList());
            }
            result.putAll(additionMap);
        }
    }
}

