/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.polyfill;

import com.github.yizzuide.milkomeda.hydrogen.interceptor.HydrogenMappedInterceptor;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.HandlerExceptionResolverComposite;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

public class SpringMvcPolyfill {
    private static final Logger log = LoggerFactory.getLogger(SpringMvcPolyfill.class);
    private static Field adaptedInterceptorsField;

    public static void addDynamicExceptionAdvice(HandlerExceptionResolver handlerExceptionResolver, BeanFactory beanFactory, String beanName) {
        if (handlerExceptionResolver instanceof HandlerExceptionResolverComposite) {
            List exceptionResolvers = ((HandlerExceptionResolverComposite)handlerExceptionResolver).getExceptionResolvers();
            for (HandlerExceptionResolver exceptionResolver : exceptionResolvers) {
                ControllerAdviceBean adviceBean;
                Class beanType;
                if (!(exceptionResolver instanceof ExceptionHandlerExceptionResolver)) continue;
                HashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver> resolverMap = (HashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver>)ReflectUtil.invokeFieldPath(exceptionResolver, "exceptionHandlerAdviceCache");
                if (resolverMap == null) {
                    resolverMap = new HashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver>(2);
                }
                if ((beanType = (adviceBean = new ControllerAdviceBean(beanName, (BeanFactory)ApplicationContextHolder.get(), null)).getBeanType()) == null) {
                    throw new IllegalStateException("SpringMvcPolyfill find unresolvable type for ControllerAdviceBean: " + adviceBean);
                }
                ExceptionHandlerMethodResolver resolver = new ExceptionHandlerMethodResolver(beanType);
                if (!resolver.hasExceptionMappings()) break;
                resolverMap.put(adviceBean, resolver);
                break;
            }
        }
    }

    public static void addDynamicResponseBodyAdvice(List<HandlerMethodReturnValueHandler> returnValueHandlers, ResponseBodyAdvice<?> responseBodyAdvice) {
        if (CollectionUtils.isEmpty(returnValueHandlers)) {
            return;
        }
        for (HandlerMethodReturnValueHandler returnValueHandler : returnValueHandlers) {
            List advices;
            if (!(returnValueHandler instanceof AbstractMessageConverterMethodArgumentResolver) || CollectionUtils.isEmpty((Collection)(advices = (List)ReflectUtil.invokeFieldPath(returnValueHandler, "advice.responseBodyAdvice")))) continue;
            advices.add(responseBodyAdvice);
        }
    }

    public static void addDynamicInterceptor(HandlerInterceptor interceptor, int order, List<String> includeURLs, List<String> excludeURLs, AbstractHandlerMapping handlerMapping) {
        String[] include = StringUtils.toStringArray(includeURLs);
        String[] exclude = StringUtils.toStringArray(excludeURLs);
        HydrogenMappedInterceptor hmi = new HydrogenMappedInterceptor(new MappedInterceptor(include, exclude, interceptor));
        hmi.setOrder(order);
        try {
            SpringMvcPolyfill.findAdaptedInterceptorsField(handlerMapping);
            List handlerInterceptors = (List)adaptedInterceptorsField.get(handlerMapping);
            boolean mapped = handlerInterceptors.stream().anyMatch(itor -> {
                if (itor instanceof HydrogenMappedInterceptor) {
                    return itor.equals(hmi);
                }
                return false;
            });
            if (mapped) {
                return;
            }
            handlerInterceptors.add(hmi);
            handlerInterceptors = handlerInterceptors.stream().sorted(OrderComparator.INSTANCE.withSourceProvider(itor -> {
                if (itor instanceof HydrogenMappedInterceptor) {
                    return ((HydrogenMappedInterceptor)itor)::getOrder;
                }
                return null;
            })).collect(Collectors.toList());
            adaptedInterceptorsField.set(handlerMapping, handlerInterceptors);
        }
        catch (Exception e) {
            log.error("SpringMvcPolyfill invoke AbstractHandlerMapping.adaptedInterceptors error with msg: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void removeDynamicInterceptor(HandlerInterceptor interceptor, AbstractHandlerMapping handlerMapping) {
        if (interceptor == null) {
            return;
        }
        try {
            SpringMvcPolyfill.findAdaptedInterceptorsField(handlerMapping);
            List handlerInterceptors = (List)adaptedInterceptorsField.get(handlerMapping);
            List shouldRemoveInterceptors = handlerInterceptors.stream().filter(itor -> {
                if (itor instanceof HydrogenMappedInterceptor) {
                    return itor.equals(interceptor);
                }
                return false;
            }).collect(Collectors.toList());
            handlerInterceptors.removeAll(shouldRemoveInterceptors);
            adaptedInterceptorsField.set(handlerMapping, handlerInterceptors);
        }
        catch (Exception e) {
            log.error("SpringMvcPolyfill invoke AbstractHandlerMapping.adaptedInterceptors error with msg: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void findAdaptedInterceptorsField(AbstractHandlerMapping handlerMapping) throws NoSuchFieldException {
        if (adaptedInterceptorsField == null) {
            Class<?> abstractHandlerMapping;
            for (abstractHandlerMapping = handlerMapping.getClass(); abstractHandlerMapping != AbstractHandlerMapping.class; abstractHandlerMapping = abstractHandlerMapping.getSuperclass()) {
            }
            adaptedInterceptorsField = abstractHandlerMapping.getDeclaredField("adaptedInterceptors");
            adaptedInterceptorsField.setAccessible(true);
        }
    }

    public static List<Map<String, String>> getInterceptorsInfo(AbstractHandlerMapping handlerMapping) {
        try {
            List handlerInterceptors = (List)adaptedInterceptorsField.get(handlerMapping);
            return handlerInterceptors.stream().map(interceptor -> {
                MappedInterceptor mappedInterceptor = null;
                HashMap<String, String> map = new HashMap<String, String>();
                String clazz = "";
                String include = "[/**]";
                String exclude = "[]";
                String order = "unknown";
                if (interceptor instanceof HydrogenMappedInterceptor) {
                    mappedInterceptor = ((HydrogenMappedInterceptor)interceptor).getMappedInterceptor();
                    order = String.valueOf(((HydrogenMappedInterceptor)interceptor).getOrder());
                } else if (interceptor instanceof MappedInterceptor) {
                    mappedInterceptor = (MappedInterceptor)interceptor;
                } else {
                    clazz = interceptor.getClass().getName();
                }
                if (mappedInterceptor != null) {
                    clazz = mappedInterceptor.getInterceptor().getClass().getName();
                    include = Arrays.toString(mappedInterceptor.getPathPatterns());
                    try {
                        Field excludePatternsField = mappedInterceptor.getClass().getDeclaredField("excludePatterns");
                        excludePatternsField.setAccessible(true);
                        exclude = Arrays.toString((String[])excludePatternsField.get(mappedInterceptor));
                    }
                    catch (Exception e) {
                        log.error("SpringMvcPolyfill invoke get error with msg: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                map.put("class", clazz);
                map.put("include", include);
                map.put("exclude", exclude);
                map.put("order", order);
                return map;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("SpringMvcPolyfill invoke get error with msg: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

