/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.universe.polyfill;

import com.github.yizzuide.milkomeda.universe.context.WebContext;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.core.ApplicationFilterRegistration;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class TomcatPolyfill {
    private static final Logger log = LoggerFactory.getLogger(TomcatPolyfill.class);

    public static boolean addDynamicFilter(ServletContext servletContext, ConfigurableApplicationContext applicationContext, String name, Class<? extends Filter> clazz, String ... urlPattern) {
        Filter filterBean = WebContext.registerBean(applicationContext, name, clazz, new Object[0]);
        applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)filterBean);
        Context standContext = (Context)ReflectUtil.invokeFieldPath(servletContext, "context.context");
        if (standContext == null) {
            log.warn("Hydrogen filter find path '((ApplicationContextFacade) servletContext).context.context' fail.");
            return false;
        }
        FilterDef filterDef = (FilterDef)ReflectUtil.invokeMethod(standContext, "findFilterDef", new Class[]{String.class}, name);
        if (filterDef != null) {
            return false;
        }
        filterDef = new FilterDef();
        filterDef.setFilterName(name);
        ReflectUtil.invokeMethod(standContext, "addFilterDef", new Class[]{FilterDef.class}, filterDef);
        filterDef.setFilterClass(filterBean.getClass().getName());
        filterDef.setFilter(filterBean);
        ApplicationFilterRegistration filterRegistration = new ApplicationFilterRegistration(filterDef, standContext);
        filterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, urlPattern);
        return (Boolean)ReflectUtil.invokeMethod(standContext, "filterStart", null, new Object[0]);
    }

    public static boolean removeDynamicFilter(String name, ServletContext servletContext) {
        Map filterConfigs;
        FilterDef filterDef;
        Context standContext = (Context)ReflectUtil.invokeFieldPath(servletContext, "context.context");
        if (standContext == null) {
            log.warn("Hydrogen filter find path '((ApplicationContextFacade) servletContext).context.context' fail.");
            return false;
        }
        FilterMap[] filterMaps = (FilterMap[])ReflectUtil.invokeMethod(standContext, "findFilterMaps", null, new Object[0]);
        if (filterMaps == null) {
            log.warn("Hydrogen filter find path '((ApplicationContextFacade) servletContext).context.context.findFilterMaps()' fail.");
            return false;
        }
        for (FilterMap filterMap : filterMaps) {
            if (!filterMap.getFilterName().equals(name)) continue;
            ReflectUtil.invokeMethod(standContext, "removeFilterMap", new Class[]{FilterMap.class}, filterMap);
            break;
        }
        if ((filterDef = (FilterDef)ReflectUtil.invokeMethod(standContext, "findFilterDef", new Class[]{String.class}, name)) != null) {
            ReflectUtil.invokeMethod(standContext, "removeFilterDef", new Class[]{FilterDef.class}, filterDef);
        }
        if ((filterConfigs = (Map)ReflectUtil.invokeFieldPath(standContext, "filterConfigs")) == null) {
            log.warn("Hydrogen filter find path '((ApplicationContextFacade) servletContext).context.context.filterConfigs' fail.");
            return false;
        }
        filterConfigs.remove(name);
        return (Boolean)ReflectUtil.invokeMethod(standContext, "filterStart", null, new Object[0]);
    }
}

