/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DataTypeConvertUtil {
    private static final Pattern linePattern = Pattern.compile("_(\\w)");

    public static String lineToSnakeStyle(String str) {
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static Long toLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Double || obj instanceof Float) {
            return Long.valueOf(org.apache.commons.lang3.StringUtils.substringBefore((String)obj.toString(), (String)"."));
        }
        if (obj instanceof Number) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        return 0L;
    }

    public static Integer toInt(Object obj) {
        return DataTypeConvertUtil.toLong(obj).intValue();
    }

    public static Integer intVal(Long num) {
        int n = num.intValue();
        return n;
    }

    public static String byte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (byte b : buf) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] hexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static Map<String, Object> beanToMap(Object object) {
        HashMap<String, Object> map;
        try {
            PropertyDescriptor[] propertyDescriptors;
            map = new HashMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.compareToIgnoreCase("class") == 0) continue;
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(object, new Object[0]) : null;
                map.put(key, value);
            }
            map.remove("class");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, Object>();
        }
        Set set = map.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (map.get(key) != null && map.get(key) != "") continue;
            map.remove(key);
            set = map.keySet();
            it = set.iterator();
        }
        return map;
    }

    public static Map<String, Object> sortMap(Map<String, Object> map, boolean deleteNullValue) {
        if (deleteNullValue) {
            DataTypeConvertUtil.clearEmptyValue(map);
        }
        return new TreeMap<String, Object>(map);
    }

    public static void clearEmptyValue(Map<String, Object> map) {
        ArrayList<String> filterList = new ArrayList<String>();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            if (val != null && (!(val instanceof String) || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((CharSequence)val)))) continue;
            filterList.add(key);
        }
        for (String key : filterList) {
            map.remove(key);
        }
    }

    public static String map2FormData(Map<String, Object> map, boolean deleteNullValue) {
        map = DataTypeConvertUtil.sortMap(map, deleteNullValue);
        int count = map.size();
        StringBuilder builder = new StringBuilder(32);
        int index = 0;
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            StringBuilder value = new StringBuilder();
            if (obj instanceof List) {
                List list = (List)obj;
                for (int i = 0; i < list.size(); ++i) {
                    value.append(list.get(i).toString());
                    if (i >= list.size() - 1) continue;
                    builder.append(",");
                }
            } else {
                value.append(obj.toString());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)value.toString())) {
                builder.append(key).append('=').append(value.toString());
                if (index < count - 1) {
                    builder.append("&");
                }
            }
            ++index;
        }
        return builder.toString();
    }

    public static String extractValue(String key, Map<String, Object> source) {
        return DataTypeConvertUtil.extractValue(key, source, null);
    }

    public static String extractValue(String key, Map<String, Object> source, String defaultValue) {
        if (key == null || source == null) {
            return defaultValue;
        }
        Object value = source.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static String extractPath(String keyPath, Map<String, Object> source, String defaultValue) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyPath)) {
            return defaultValue;
        }
        if (!keyPath.contains(".")) {
            return DataTypeConvertUtil.extractValue(keyPath, source, defaultValue);
        }
        String[] keys = StringUtils.delimitedListToStringArray((String)keyPath, (String)".");
        Map<String, Object> nodeMap = new HashMap<String, Object>(source);
        for (String key : keys) {
            if (!key.endsWith("]")) {
                Object node = nodeMap.get(key);
                if (node == null) {
                    return defaultValue;
                }
                if (DataTypeConvertUtil.isSugarType(node)) {
                    return node.toString();
                }
                nodeMap = (Map)node;
                continue;
            }
            int startBracket = key.indexOf(91);
            int index = Integer.parseInt(key.substring(startBracket + 1, key.indexOf(93)));
            Object node = nodeMap.get(key = key.substring(0, startBracket));
            if (node == null) {
                return defaultValue;
            }
            if (DataTypeConvertUtil.isSugarType(node)) {
                return node.toString();
            }
            if (node instanceof List) {
                if (CollectionUtils.isEmpty((Collection)((List)node))) {
                    return defaultValue;
                }
                Object value = ((List)node).get(index);
                if (value == null) {
                    return defaultValue;
                }
                if (DataTypeConvertUtil.isSugarType(value)) {
                    return value.toString();
                }
                nodeMap = (Map)value;
                continue;
            }
            nodeMap = (Map)node;
        }
        return defaultValue;
    }

    public static boolean isSugarType(Object obj) {
        return !(obj instanceof List) && !(obj instanceof Map);
    }
}

