/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.util;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EncryptUtil {
    private static final Logger log = LoggerFactory.getLogger(EncryptUtil.class);
    private static final String CHARSET = "UTF-8";
    public static final String SIGN_TYPE_RSA1 = "SHA1WithRSA";
    public static final String SIGN_TYPE_RSA2 = "SHA256WithRSA";

    public static String encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decode(String data) {
        return StringUtils.isEmpty((Object)data) ? null : Base64.getDecoder().decode(data);
    }

    public static String generateKey() {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance("aes");
        }
        catch (NoSuchAlgorithmException e) {
            log.info("Encrypt happen exception: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        keyGenerator.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        return EncryptUtil.encode(secretKey.getEncoded());
    }

    public static String encrypt(String aesKey, String content) {
        byte[] result;
        SecretKeySpec key = new SecretKeySpec(Objects.requireNonNull(EncryptUtil.decode(aesKey)), "aes");
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, key);
            result = cipher.doFinal(content.getBytes(CHARSET));
        }
        catch (Exception e) {
            log.info("Encrypt happen exception: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        return EncryptUtil.encode(result);
    }

    public static String decrypt(String aesKey, String encode64Content) {
        String source;
        SecretKeySpec key = new SecretKeySpec(Objects.requireNonNull(EncryptUtil.decode(aesKey)), "aes");
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(Objects.requireNonNull(EncryptUtil.decode(encode64Content)));
            source = new String(result, CHARSET);
        }
        catch (Exception e) {
            log.info("Encrypt happen exception: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        return source;
    }

    public static void genKeyPair() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGen.generateKeyPair();
            String priKey = EncryptUtil.encode(keyPair.getPrivate().getEncoded());
            String pubKey = EncryptUtil.encode(keyPair.getPublic().getEncoded());
            System.out.println("priKey: " + priKey);
            System.out.println("pubKey: " + pubKey);
        }
        catch (NoSuchAlgorithmException e) {
            log.info("Encrypt happen exception: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static String encryptByPublicKey(String pubKey, String data) {
        byte[] output;
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Objects.requireNonNull(EncryptUtil.decode(pubKey)));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            output = EncryptUtil.blockCodec(cipher, 1, data.getBytes(CHARSET));
        }
        catch (Exception e) {
            log.info("Encrypt happen exception: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        return EncryptUtil.encode(output);
    }

    public static String decryptByPrivateKey(String priKey, String data) {
        String source;
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Objects.requireNonNull(EncryptUtil.decode(priKey)));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, privateKey);
            byte[] output = EncryptUtil.blockCodec(cipher, 2, EncryptUtil.decode(data));
            source = new String(output, CHARSET);
        }
        catch (Exception e) {
            log.info("Encrypt happen exception: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        return source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] blockCodec(Cipher cipher, int mode, byte[] dataByte) {
        int maxBlock = mode == 2 ? 128 : 117;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int offSet = 0;
            int i = 0;
            while (dataByte.length > offSet) {
                byte[] buff = dataByte.length - offSet > maxBlock ? cipher.doFinal(dataByte, offSet, maxBlock) : cipher.doFinal(dataByte, offSet, dataByte.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u5757\u5927\u5c0f\u4e3a[" + maxBlock + "]\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    public static String sign(String data, String priKey, String signType) {
        byte[] sign;
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Objects.requireNonNull(EncryptUtil.decode(priKey)));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            Signature signature = Signature.getInstance(signType);
            signature.initSign(privateKey);
            signature.update(data.getBytes(CHARSET));
            sign = signature.sign();
        }
        catch (Exception e) {
            log.info("Encrypt happen exception: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        return EncryptUtil.encode(sign);
    }

    public static boolean verify(String data, String sign, String pubKey, String signType) {
        boolean verify;
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Objects.requireNonNull(EncryptUtil.decode(pubKey)));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Signature signature = Signature.getInstance(signType);
            signature.initVerify(publicKey);
            signature.update(data.getBytes(CHARSET));
            verify = signature.verify(EncryptUtil.decode(sign));
        }
        catch (Exception e) {
            log.info("Encrypt happen exception: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        return verify;
    }
}

