/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.yizzuide.milkomeda.util.DataTypeConvertUtil;
import com.github.yizzuide.milkomeda.util.TypeUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static final Logger log = LoggerFactory.getLogger(JSONUtil.class);
    public static final ObjectMapper mapper = new ObjectMapper();

    public static String serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("serialize error\uff1a{}", obj, (Object)e);
            return null;
        }
    }

    public static <T> T parse(String json, Class<T> tClass) {
        try {
            return (T)mapper.readValue(json, tClass);
        }
        catch (IOException e) {
            log.error("parse error\uff1a{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <E> List<E> parseList(String json, Class<E> eClass) {
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, eClass));
        }
        catch (IOException e) {
            log.error("parse error\uff1a{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <K, V> Map<K, V> parseMap(String json, Class<K> kClass, Class<V> vClass) {
        try {
            return (Map)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, kClass, vClass));
        }
        catch (IOException e) {
            log.error("parse error\uff1a{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T nativeRead(String json, TypeReference<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            log.error("parse error\uff1a{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T nativeRead(String json, JavaType javaType) {
        try {
            return (T)mapper.readValue(json, javaType);
        }
        catch (IOException e) {
            log.error("parse error\uff1a{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T toCamel(Object data, TypeReference<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object result = data;
        if (data instanceof Map) {
            result = JSONUtil.toCamel(data);
            if (Map.class == TypeUtil.type2Class(clazz)) {
                return (T)result;
            }
        } else if (data instanceof List) {
            List list = (List)((Object)data);
            ArrayList<Map<String, Object>> targetList = new ArrayList<Map<String, Object>>();
            for (Map m : list) {
                targetList.add(JSONUtil.toCamel(m));
            }
            result = targetList;
            if (List.class == TypeUtil.type2Class(clazz)) {
                return (T)result;
            }
        }
        String jsonString = mapper.writeValueAsString(result);
        return (T)mapper.readValue(jsonString, clazz);
    }

    public static Map<String, Object> toCamel(Map data) {
        HashMap<String, Object> tmpMap = new HashMap<String, Object>();
        for (Object k : data.keySet()) {
            Object v = data.get(k);
            if (v instanceof Map) {
                v = JSONUtil.toCamel((Map)v);
            } else if (v instanceof List) {
                List list = (List)v;
                ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
                for (Object map : list) {
                    mapList.add(JSONUtil.toCamel((Map)map));
                }
                v = mapList;
            }
            tmpMap.put(DataTypeConvertUtil.lineToSnakeStyle((String)k), v);
        }
        return tmpMap;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TimeZone china = TimeZone.getTimeZone("GMT+08:00");
        mapper.setTimeZone(china);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

