/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;

public class JwtUtil {
    public static String generateToken(Map<String, Object> claims, PrivateKey privateKey, int expireMinutes) {
        return Jwts.builder().setClaims(claims).setExpiration(DateTime.now().plusMinutes(expireMinutes).toDate()).signWith(SignatureAlgorithm.RS256, (Key)privateKey).compact();
    }

    public static String generateToken(Map<String, Object> claims, String secureKey, int expireMinutes, boolean usedRSA) {
        return Jwts.builder().setClaims(claims).setExpiration(DateTime.now().plusMinutes(expireMinutes).toDate()).signWith(usedRSA ? SignatureAlgorithm.RS256 : SignatureAlgorithm.HS512, secureKey).compact();
    }

    public static Claims parseToken(String token, PublicKey publicKey) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return (Claims)Jwts.parser().setSigningKey((Key)publicKey).parseClaimsJws(token).getBody();
    }

    public static Claims parseToken(String token, String secureKey) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, IllegalArgumentException {
        return (Claims)Jwts.parser().setSigningKey(secureKey).parseClaimsJws(token).getBody();
    }

    public static Boolean isTokenExpired(String token, PublicKey publicKey) {
        try {
            Claims claims = JwtUtil.parseToken(token, publicKey);
            Date expiration = claims.getExpiration();
            return expiration.before(new Date());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Boolean isTokenExpired(String token, String secureKey) {
        try {
            Claims claims = JwtUtil.parseToken(token, secureKey);
            Date expiration = claims.getExpiration();
            return expiration.before(new Date());
        }
        catch (Exception e) {
            return false;
        }
    }
}

