/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.util;

import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderResolver {
    private static final Logger log = LoggerFactory.getLogger(PlaceholderResolver.class);
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    private static final PlaceholderResolver defaultResolver = new PlaceholderResolver();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";

    private PlaceholderResolver() {
    }

    private PlaceholderResolver(String placeholderPrefix, String placeholderSuffix) {
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
    }

    public static PlaceholderResolver getDefaultResolver() {
        return defaultResolver;
    }

    public static PlaceholderResolver getResolver(String placeholderPrefix, String placeholderSuffix) {
        return new PlaceholderResolver(placeholderPrefix, placeholderSuffix);
    }

    public List<String> getPlaceHolders(String content) {
        int start = content.indexOf(this.placeholderPrefix);
        if (start == -1) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>();
        while (start != -1) {
            int end = content.indexOf(this.placeholderSuffix, start + 1);
            String subContent = content.substring(start + 1, end);
            if (subContent.contains(this.placeholderPrefix)) {
                start = content.indexOf(this.placeholderPrefix, start + 1);
                continue;
            }
            keys.add(subContent);
            start = content.indexOf(this.placeholderPrefix, end + 1);
        }
        return keys;
    }

    public String resolve(String content, String ... values) {
        int start = content.indexOf(this.placeholderPrefix);
        if (start == -1) {
            return content;
        }
        int valueIndex = 0;
        StringBuilder result = new StringBuilder(content);
        while (start != -1) {
            int end = result.indexOf(this.placeholderSuffix);
            String replaceContent = values[valueIndex++];
            result.replace(start, end + this.placeholderSuffix.length(), replaceContent);
            start = result.indexOf(this.placeholderPrefix, start + replaceContent.length());
        }
        return result.toString();
    }

    public String resolve(String content, Object[] values) {
        return this.resolve(content, (String[])Stream.of(values).map(String::valueOf).toArray(String[]::new));
    }

    public String resolveByRule(String content, Function<String, String> rule) {
        int start = content.indexOf(this.placeholderPrefix);
        if (start == -1) {
            return content;
        }
        StringBuilder result = new StringBuilder(content);
        while (start != -1) {
            String replaceContent;
            int end = result.indexOf(this.placeholderSuffix, start);
            String placeholder = result.substring(start + this.placeholderPrefix.length(), end);
            if (placeholder.contains(this.placeholderPrefix)) {
                start = content.indexOf(this.placeholderPrefix, start + 1);
                continue;
            }
            String string = replaceContent = placeholder.trim().isEmpty() ? "" : rule.apply(placeholder);
            if (replaceContent == null) {
                replaceContent = "";
            }
            result.replace(start, end + this.placeholderSuffix.length(), replaceContent);
            start = result.indexOf(this.placeholderPrefix, start + replaceContent.length());
        }
        return result.toString();
    }

    public String resolveByMap(String content, Map<String, Object> valueMap) {
        return this.resolveByRule(content, placeholderValue -> String.valueOf(valueMap.get(placeholderValue)));
    }

    public String resolveByProperties(String content, Properties properties) {
        return this.resolveByRule(content, properties::getProperty);
    }

    public String resolveByObject(String content, Object obj) {
        if (obj instanceof Map) {
            return this.resolveByMap(content, (Map)obj);
        }
        return this.resolveByRule(content, placeholderValue -> (String)ReflectUtil.invokeFieldPath(obj, placeholderValue));
    }
}

