/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtil {
    private static final Logger log = LoggerFactory.getLogger(RSAUtil.class);

    public static PublicKey getPublicKey(String filename) throws Exception {
        byte[] bytes = RSAUtil.readFile(filename);
        return RSAUtil.getPublicKey(bytes);
    }

    public static PublicKey getPublicKey2(String base64String) throws Exception {
        byte[] bytes = Base64.decodeBase64((String)base64String);
        return RSAUtil.getPublicKey(bytes);
    }

    public static PrivateKey getPrivateKey(String filename) throws Exception {
        byte[] bytes = RSAUtil.readFile(filename);
        return RSAUtil.getPrivateKey(bytes);
    }

    public static PrivateKey getPrivateKey2(String base64String) throws Exception {
        byte[] bytes = Base64.decodeBase64((String)base64String);
        return RSAUtil.getPrivateKey(bytes);
    }

    public static PublicKey getPublicKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePublic(spec);
    }

    public static PrivateKey getPrivateKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(spec);
    }

    public static void generateKey(String publicKeyFilename, String privateKeyFilename, String secret) throws IOException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom secureRandom = new SecureRandom(secret.getBytes());
        keyPairGenerator.initialize(1024, secureRandom);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        byte[] publicKeyBytes = keyPair.getPublic().getEncoded();
        String publicKeyString = Base64.encodeBase64String((byte[])publicKeyBytes);
        log.info("\u751f\u6210\u516c\u94a5\u4e32\uff1a{}", (Object)publicKeyString);
        RSAUtil.writeFile(publicKeyFilename, publicKeyBytes);
        byte[] privateKeyBytes = keyPair.getPrivate().getEncoded();
        RSAUtil.writeFile(privateKeyFilename, privateKeyBytes);
        String privateKeyString = Base64.encodeBase64String((byte[])privateKeyBytes);
        log.info("\u751f\u6210\u79c1\u94a5\u4e32\uff1a{}", (Object)privateKeyString);
    }

    private static byte[] readFile(String fileName) throws IOException {
        return Files.readAllBytes(new File(fileName).toPath());
    }

    private static void writeFile(String destPath, byte[] bytes) throws IOException {
        File dest = new File(destPath);
        File dir = dest.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dest.exists()) {
            dest.createNewFile();
        }
        Files.write(dest.toPath(), bytes, new OpenOption[0]);
    }
}

