/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.util;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class RedisUtil {
    public static Boolean setIfAbsent(String key, long liveTime, RedisTemplate<String, String> redisTemplate) {
        return redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"1", liveTime, TimeUnit.SECONDS);
    }

    public static Long incr(String key, long delta, Date expireDate, RedisTemplate redisTemplate) {
        assert (redisTemplate.getConnectionFactory() != null);
        RedisAtomicLong ral = new RedisAtomicLong(key, redisTemplate.getConnectionFactory());
        long increment = ral.addAndGet(delta);
        if (expireDate != null) {
            ral.expireAt(expireDate);
        }
        return increment;
    }

    public static Long incr(String key, long delta, long liveTime, RedisTemplate redisTemplate) {
        assert (redisTemplate.getConnectionFactory() != null);
        RedisAtomicLong ral = new RedisAtomicLong(key, redisTemplate.getConnectionFactory());
        long increment = ral.addAndGet(delta);
        if (liveTime != 0L) {
            ral.expire(liveTime, TimeUnit.SECONDS);
        }
        return increment;
    }

    public static void batchOps(final Runnable runnable, RedisTemplate<String, String> redisTemplate) {
        redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                runnable.run();
                return null;
            }
        });
    }
}

