/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.util;

import com.github.yizzuide.milkomeda.universe.el.ELContext;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ReflectUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtil.class);

    public static Class<?>[] getClassOfParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] subTypes = pt.getActualTypeArguments();
            Class[] classes = new Class[subTypes.length];
            for (int i = 0; i < subTypes.length; ++i) {
                Class clazz;
                classes[i] = clazz = (Class)((ParameterizedType)subTypes[i]).getRawType();
            }
            return classes;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(JoinPoint joinPoint, Class<T> annotationClass) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        return methodSignature.getMethod().getAnnotation(annotationClass);
    }

    public static Object[] injectParam(JoinPoint joinPoint, Object obj, Annotation type, boolean check) {
        Object[] args = joinPoint.getArgs();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            if (!obj.getClass().isInstance(args[i])) continue;
            args[i] = obj;
            return args;
        }
        if (check) {
            throw new IllegalArgumentException("You must add " + obj.getClass().getSimpleName() + " parameter on method " + joinPoint.getSignature().getName() + " before use @" + type.annotationType().getSimpleName() + ".");
        }
        return args;
    }

    public static String extractValue(JoinPoint joinPoint, String express) {
        if (express.startsWith(":")) {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            assert (attributes != null);
            String headerName = express.substring(1);
            String value = attributes.getRequest().getHeader(headerName);
            if (StringUtils.isEmpty((Object)headerName) || StringUtils.isEmpty((Object)value)) {
                throw new IllegalArgumentException("Can't find " + headerName + " from HTTP header.");
            }
            return value;
        }
        if (express.startsWith("'") || express.startsWith("@") || express.startsWith("#") || express.startsWith("T(") || express.startsWith("args[")) {
            return ELContext.getValue(joinPoint, express);
        }
        return express;
    }

    public static <T> void invokeWithWrapperInject(Object target, Method method, List<T> wrapperList, Class<T> wrapperClazz, Function<T, Object> wrapperBody, BiConsumer<T, Object> wipeWrapperBody) throws IllegalAccessException, InvocationTargetException {
        if (method.getParameterTypes().length == 0) {
            method.invoke(target, new Object[0]);
            return;
        }
        ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)0);
        Class parameterClazz = resolvableType.resolve();
        if (parameterClazz == Map.class || parameterClazz == Object.class) {
            method.invoke(target, wrapperBody.apply(wrapperList.get(0)));
            return;
        }
        if (parameterClazz == List.class) {
            ResolvableType[] wrapperGenerics = resolvableType.getGenerics();
            Class elementGenericType = wrapperGenerics[0].resolve();
            if (elementGenericType == null) {
                method.invoke(target, wrapperList.stream().map(wrapperBody).collect(Collectors.toList()));
                return;
            }
            if (elementGenericType == Map.class) {
                method.invoke(target, wrapperList.stream().map(wrapperBody).collect(Collectors.toList()));
                return;
            }
            if (elementGenericType == wrapperClazz) {
                Class entityGenericType = wrapperGenerics[0].getGeneric(new int[]{0}).resolve();
                if (entityGenericType == null) {
                    method.invoke(target, wrapperList);
                    return;
                }
                if (entityGenericType == Map.class) {
                    method.invoke(target, wrapperList);
                    return;
                }
                for (T wrapper2 : wrapperList) {
                    Object body = JSONUtil.parse(JSONUtil.serialize(wrapperBody.apply(wrapper2)), entityGenericType);
                    wipeWrapperBody.accept(wrapper2, body);
                }
                method.invoke(target, wrapperList);
                return;
            }
            method.invoke(target, wrapperList.stream().map(wrapper -> JSONUtil.parse(JSONUtil.serialize(wrapperBody.apply(wrapper)), elementGenericType)).collect(Collectors.toList()));
            return;
        }
        method.invoke(target, JSONUtil.parse(JSONUtil.serialize(wrapperBody.apply(wrapperList.get(0))), parameterClazz));
    }

    public static Object getMethodDefaultReturnVal(JoinPoint joinPoint) {
        Class<?> retType = ReflectUtil.getMethodReturnType(joinPoint);
        if (Long.class == retType) {
            return -1L;
        }
        if (Long.TYPE == retType || Integer.TYPE == retType || Short.TYPE == retType || Float.TYPE == retType || Double.TYPE == retType || Number.class.isAssignableFrom(retType)) {
            return -1;
        }
        if (Boolean.TYPE == retType || Boolean.class.isAssignableFrom(retType)) {
            return false;
        }
        if (Byte.TYPE == retType || Byte.class.isAssignableFrom(retType)) {
            return 0;
        }
        if (Character.TYPE == retType || Character.class.isAssignableFrom(retType)) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    public static Class<?> getMethodReturnType(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        return ReflectUtil.getMethodReturnType(signature.getMethod());
    }

    public static Class<?> getMethodReturnType(Method method) {
        return ResolvableType.forMethodReturnType((Method)method).resolve();
    }

    public static <T> T invokeFieldPath(Object target, String fieldPath) {
        String[] fieldNames;
        if (target == null || StringUtils.isEmpty((Object)fieldPath)) {
            return null;
        }
        for (String fieldName : fieldNames = StringUtils.delimitedListToStringArray((String)fieldPath, (String)".")) {
            Field field = ReflectionUtils.findField(Objects.requireNonNull(target).getClass(), (String)fieldName);
            if (field == null) {
                return null;
            }
            ReflectionUtils.makeAccessible((Field)field);
            target = ReflectionUtils.getField((Field)field, (Object)target);
        }
        return (T)target;
    }

    public static void setField(Object target, Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            Field field = ReflectionUtils.findField(target.getClass(), (String)entry.getKey());
            if (field == null) continue;
            ReflectionUtils.makeAccessible((Field)field);
            if (Enum.class.isAssignableFrom(field.getType()) && entry.getValue() instanceof String) {
                ReflectionUtils.setField((Field)field, (Object)target, Enum.valueOf(field.getType(), (String)entry.getValue()));
                continue;
            }
            if (Long.class.isAssignableFrom(field.getType()) && entry.getValue() instanceof Integer) {
                ReflectionUtils.setField((Field)field, (Object)target, (Object)Long.valueOf(String.valueOf(entry.getValue())));
                continue;
            }
            if (List.class.isAssignableFrom(field.getType()) && entry.getValue() instanceof Map) {
                ReflectionUtils.setField((Field)field, (Object)target, new ArrayList(((LinkedHashMap)entry.getValue()).values()));
                continue;
            }
            ReflectionUtils.setField((Field)field, (Object)target, (Object)entry.getValue());
        }
    }

    public static <T> T invokeMethod(Object target, String methodName, Class<?>[] paramTypes, Object ... args) {
        Method method = ReflectionUtils.findMethod(target.getClass(), (String)methodName, (Class[])paramTypes);
        if (method == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Method)method);
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])args);
    }
}

