/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events.emitter;

import com.github.yoojia.events.emitter.DeadEvent;
import com.github.yoojia.events.emitter.EventEmitter;
import com.github.yoojia.events.emitter.EventInterceptor;
import com.github.yoojia.events.emitter.RealSubscriber;
import com.github.yoojia.events.emitter.Subscriber;
import java.util.ArrayList;
import java.util.List;

class Submit {
    private static final int GUESS = 4;
    private final EventEmitter mEmitter;

    public Submit(EventEmitter mEmitter) {
        this.mEmitter = mEmitter;
    }

    public void submit(Object event) {
        List<Subscriber> subscribers = this.findSubscribers(event, this.mEmitter);
        if (subscribers.isEmpty() && !(event instanceof DeadEvent)) {
            this.mEmitter.emit(new DeadEvent(event));
        } else {
            int size = this.mEmitter.eventInterceptors.size();
            for (int i = 0; i < size; ++i) {
                EventInterceptor interceptor = this.mEmitter.eventInterceptors.get(i);
                if (!interceptor.handle(event)) continue;
                return;
            }
            this.mEmitter.scheduler.schedule(event, subscribers);
        }
    }

    private List<Subscriber> findSubscribers(Object event, EventEmitter emitter) {
        ArrayList<Subscriber> out = new ArrayList<Subscriber>(4);
        for (RealSubscriber real : emitter.subscribers) {
            if (!real.accept(event)) continue;
            out.add(real.subscriber);
        }
        return out;
    }
}

