/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.web;

import com.github.yoojia.web.Request;
import com.github.yoojia.web.Response;
import com.github.yoojia.web.StatusCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/yoojia/web/TransferAdapter;", "", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "inputFilter", "Ljava/io/File;", "lastModified", "", "dispatch", "", "request", "Lcom/github/yoojia/web/Request;", "response", "Lcom/github/yoojia/web/Response;", "assets-compileKotlin"})
public final class TransferAdapter {
    private final File inputFilter;
    private final long lastModified;

    public final void dispatch(@NotNull Request request, @NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        String serverDate = new Date(this.lastModified).toString();
        String clientDate = request.header("If-Modified-Since");
        if (serverDate.equals(clientDate)) {
            response.setStatusCode(StatusCode.NOT_MODIFIED);
        } else {
            String string = serverDate;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"serverDate");
            response.addHeader("Last-Modified", string);
            FileChannel file = new FileInputStream(this.inputFilter).getChannel();
            WritableByteChannel out = Channels.newChannel((OutputStream)response.servletResponse.getOutputStream());
            file.transferTo(0L, file.size(), out);
        }
    }

    public TransferAdapter(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path.toFile()");
        this.inputFilter = file;
        this.lastModified = this.inputFilter.lastModified();
    }
}

