/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.web;

import com.github.yoojia.web.RedisPlugin;
import com.github.yoojia.web.core.Config;
import com.github.yoojia.web.core.Context;
import com.github.yoojia.web.core.Plugin;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/github/yoojia/web/RedisPlugin;", "Lcom/github/yoojia/web/core/Plugin;", "()V", "onCreated", "", "context", "Lcom/github/yoojia/web/core/Context;", "config", "Lcom/github/yoojia/web/core/Config;", "onDestroy", "Companion", "redis-compileKotlin"})
public final class RedisPlugin
implements Plugin {
    private static final Logger Logger;
    private static JedisPool REAL_POOL;
    @NotNull
    private static final Lazy CONNECTION$delegate;
    public static final Companion Companion;

    public void onCreated(@NotNull Context context, @NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        String host = config.getString("host");
        String password = config.getString("password");
        int port = config.getInt("port", 6379);
        boolean secret = config.getBoolean("secret", true);
        StringBuilder log = new StringBuilder();
        log.append(", host=" + (secret ? "[secret]" : host));
        log.append(", pass=" + (secret ? "[secret]" : password));
        RedisPlugin.Companion.getLogger().debug("Init REDIS plugin: " + log);
        JedisPoolConfig jConfig = new JedisPoolConfig();
        jConfig.setMaxTotal(config.getInt("max-total", JedisPoolConfig.DEFAULT_MAX_TOTAL));
        jConfig.setMaxIdle(config.getInt("max-idle", JedisPoolConfig.DEFAULT_MAX_IDLE));
        jConfig.setMinIdle(config.getInt("min-idle", JedisPoolConfig.DEFAULT_MIN_IDLE));
        int timeout = config.getInt("timeout", 2000);
        RedisPlugin.Companion.setREAL_POOL(new JedisPool((GenericObjectPoolConfig)jConfig, host, port, timeout, password));
    }

    public void onDestroy() {
        Companion.getCONNECTION$redis_compileKotlin().destroy();
    }

    static {
        Companion = new Companion(null);
        Logger = LoggerFactory.getLogger(RedisPlugin.class);
        CONNECTION$delegate = LazyKt.lazy((Function0)Companion.CONNECTION.2.INSTANCE);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/github/yoojia/web/RedisPlugin$Companion;", "", "()V", "CONNECTION", "Lredis/clients/jedis/JedisPool;", "getCONNECTION$redis_compileKotlin", "()Lredis/clients/jedis/JedisPool;", "CONNECTION$delegate", "Lkotlin/Lazy;", "Logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "REAL_POOL", "getREAL_POOL", "setREAL_POOL", "(Lredis/clients/jedis/JedisPool;)V", "redis-compileKotlin"})
    public static final class Companion {
        private static final /* synthetic */ KProperty[] $$delegatedProperties;

        private final Logger getLogger() {
            return Logger;
        }

        private final JedisPool getREAL_POOL() {
            return REAL_POOL;
        }

        private final void setREAL_POOL(JedisPool jedisPool) {
            REAL_POOL = jedisPool;
        }

        @NotNull
        public final JedisPool getCONNECTION$redis_compileKotlin() {
            Lazy lazy = CONNECTION$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (JedisPool)lazy.getValue();
        }

        private Companion() {
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "CONNECTION", "getCONNECTION$redis_compileKotlin()Lredis/clients/jedis/JedisPool;"))};
        }

        @Nullable
        public static final /* synthetic */ JedisPool access$getREAL_POOL$p(Companion $this) {
            return $this.getREAL_POOL();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

