/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuanmomo.mybatis.mbg.plugin.dynamic;

import com.github.yuanmomo.mybatis.mbg.plugin.dynamic.MethodTypeEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ibatis.annotations.Param;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTableNamePlugin
extends PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(DynamicTableNamePlugin.class);
    private static Logger logger = LoggerFactory.getLogger(DynamicTableNamePlugin.class);
    public static final String NEW_TABLE_NAME_PARAMETER = "tableName";
    public static final String DYNAMIC_TABLE_NAME_FIELD_NAME = "dynamicTableName";
    public static boolean DYNAMIC_TABLE_NAME_PLUGIN_ACTIVE = false;

    public boolean validate(List<String> warnings) {
        DYNAMIC_TABLE_NAME_PLUGIN_ACTIVE = true;
        return DYNAMIC_TABLE_NAME_PLUGIN_ACTIVE;
    }

    public static boolean isConfigDynamic(IntrospectedTable introspectedTable) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)"true", (CharSequence[])new CharSequence[]{introspectedTable.getTableConfiguration().getProperty("dynamic")});
    }

    public static boolean providerChangeMethodParameterToMap(MethodTypeEnum typeEnum, Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (!DynamicTableNamePlugin.isConfigDynamic(introspectedTable)) {
            return true;
        }
        if (method == null || method.getBodyLines() == null) {
            return true;
        }
        String tableName = StringUtility.escapeStringForJava((String)introspectedTable.getFullyQualifiedTableNameAtRuntime());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewMapInstance());
        List parameterList = method.getParameters();
        parameterList.clear();
        parameterList.add(new Parameter(new FullyQualifiedJavaType("java.util.Map<java.lang.String, java.lang.Object>"), "parameter"));
        ArrayList<String> newBodyLines = new ArrayList<String>();
        switch (typeEnum) {
            case NORMAL: {
                FullyQualifiedJavaType record = introspectedTable.getRules().calculateAllFieldsClass();
                newBodyLines.add(String.format("%s record = (%s) parameter.get(\"record\");", record.getShortName(), record.getShortName()));
                break;
            }
            case EXAMPLE: {
                FullyQualifiedJavaType example = new FullyQualifiedJavaType(introspectedTable.getExampleType());
                topLevelClass.addImportedType(example);
                newBodyLines.add(String.format("%s example = (%s) parameter.get(\"example\");", example.getShortName(), example.getShortName()));
                break;
            }
            default: {
                return true;
            }
        }
        List bodyLines = method.getBodyLines();
        for (String bodyLine : bodyLines) {
            if (StringUtils.isBlank((CharSequence)bodyLine)) continue;
            String exampleName = introspectedTable.getExampleType();
            if (StringUtils.startsWith((CharSequence)bodyLine.trim(), (CharSequence)String.format("%s example", exampleName))) continue;
            bodyLine = DynamicTableNamePlugin.providerReplaceTableName(bodyLine, tableName, NEW_TABLE_NAME_PARAMETER);
            switch (typeEnum) {
                case NORMAL: {
                    if (StringUtils.isNotBlank((CharSequence)bodyLine) && bodyLine.trim().startsWith("sql.VALUES(")) {
                        bodyLine = bodyLine.replaceAll("#\\{", "#\\{record.");
                    }
                    if (StringUtils.isNotBlank((CharSequence)bodyLine) && bodyLine.trim().startsWith("sql.SET(") && !bodyLine.trim().contains("#{record.")) {
                        bodyLine = bodyLine.replaceAll("#\\{", "#\\{record.");
                    }
                    if (!StringUtils.isNotBlank((CharSequence)bodyLine) || !bodyLine.trim().startsWith("sql.WHERE(") || bodyLine.trim().contains("#{record.")) break;
                    bodyLine = bodyLine.replaceAll("#\\{", "#\\{record.");
                    break;
                }
                case EXAMPLE: {
                    if (!StringUtils.isNotBlank((CharSequence)bodyLine) || !bodyLine.trim().startsWith("applyWhere")) break;
                    bodyLine = "applyWhere(sql, example, true);";
                    break;
                }
            }
            newBodyLines.add(bodyLine);
        }
        DynamicTableNamePlugin.replaceMethodBody(method, newBodyLines);
        return true;
    }

    private static String providerReplaceTableName(String bodyLine, String tableName, String replaceTableName) {
        String mark = String.format("(\"%s\")", tableName);
        if (StringUtils.contains((CharSequence)bodyLine, (CharSequence)mark)) {
            String replacement = String.format("(\"%s\")", String.format("\\$\\{%s\\}", replaceTableName));
            bodyLine = bodyLine.replaceAll(mark, replacement);
        }
        return bodyLine;
    }

    public static boolean mapperAddTableNameParameter(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (!DynamicTableNamePlugin.isConfigDynamic(introspectedTable)) {
            return true;
        }
        if (method == null || method.getParameters() == null) {
            return true;
        }
        List parameters = method.getParameters();
        for (Parameter parameter : parameters) {
            Parameter originalParam = parameter;
            if (originalParam.getAnnotations() != null && originalParam.getAnnotations().size() > 0) continue;
            FullyQualifiedJavaType fullyQualifiedJavaType = new FullyQualifiedJavaType(Param.class.getName());
            interfaze.addImportedType(fullyQualifiedJavaType);
            originalParam.addAnnotation(String.format("@Param(\"%s\")", originalParam.getName()));
        }
        Parameter tableNameParameter = new Parameter(FullyQualifiedJavaType.getStringInstance(), NEW_TABLE_NAME_PARAMETER);
        tableNameParameter.addAnnotation(String.format("@Param(\"%s\")", NEW_TABLE_NAME_PARAMETER));
        parameters.add(0, tableNameParameter);
        return true;
    }

    public static void mapperReplaceAnnotationLine(IntrospectedTable introspectedTable, Method method, Pair<String, String> ... matchers) {
        if (!DynamicTableNamePlugin.isConfigDynamic(introspectedTable)) {
            return;
        }
        if (method == null || method.getAnnotations() == null || matchers == null || matchers.length == 0) {
            return;
        }
        List annotations = method.getAnnotations();
        ArrayList<String> newAnnotations = new ArrayList<String>();
        String annotationLine = null;
        Iterator iterator = annotations.iterator();
        while (iterator.hasNext()) {
            String annotation;
            annotationLine = annotation = (String)iterator.next();
            for (Pair<String, String> matcher : matchers) {
                annotationLine = StringUtils.replaceAll((String)annotationLine, (String)((String)matcher.getKey()), (String)((String)matcher.getValue()));
            }
            newAnnotations.add(String.format("%s", annotationLine));
        }
        method.getAnnotations().clear();
        method.getAnnotations().addAll(newAnnotations);
    }

    private static void replaceMethodBody(Method method, List<String> bodyLineList) {
        if (method == null || method.getBodyLines() == null) {
            return;
        }
        method.getBodyLines().clear();
        method.getBodyLines().addAll(bodyLineList);
    }

    public boolean providerCountByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.providerChangeMethodParameterToMap(MethodTypeEnum.EXAMPLE, method, topLevelClass, introspectedTable);
        return true;
    }

    public boolean clientCountByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
    }

    public boolean providerDeleteByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.providerChangeMethodParameterToMap(MethodTypeEnum.EXAMPLE, method, topLevelClass, introspectedTable);
        return true;
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        String tableName = StringUtility.escapeStringForJava((String)introspectedTable.getFullyQualifiedTableNameAtRuntime());
        DynamicTableNamePlugin.mapperReplaceAnnotationLine(introspectedTable, method, Pair.of((Object)String.format("from %s", tableName), (Object)"from \\$\\{tableName\\}"));
        return true;
    }

    public boolean clientInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (!DynamicTableNamePlugin.isConfigDynamic(introspectedTable)) {
            return true;
        }
        String tableName = StringUtility.escapeStringForJava((String)introspectedTable.getFullyQualifiedTableNameAtRuntime());
        DynamicTableNamePlugin.mapperReplaceAnnotationLine(introspectedTable, method, Pair.of((Object)String.format("into %s", tableName), (Object)"into \\$\\{dynamicTableName\\}"));
        return true;
    }

    public boolean providerInsertSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (!DynamicTableNamePlugin.isConfigDynamic(introspectedTable)) {
            return true;
        }
        List bodyLineList = method.getBodyLines();
        if (bodyLineList == null || bodyLineList.size() == 0) {
            return true;
        }
        String tableName = StringUtility.escapeStringForJava((String)introspectedTable.getFullyQualifiedTableNameAtRuntime());
        ArrayList<String> newBodyLineList = new ArrayList<String>();
        for (String bodyLine : bodyLineList) {
            newBodyLineList.add(DynamicTableNamePlugin.providerReplaceTableName(bodyLine, tableName, DYNAMIC_TABLE_NAME_FIELD_NAME));
        }
        DynamicTableNamePlugin.replaceMethodBody(method, newBodyLineList);
        return true;
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        return true;
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        return true;
    }

    public boolean providerSelectByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.providerChangeMethodParameterToMap(MethodTypeEnum.EXAMPLE, method, topLevelClass, introspectedTable);
        return true;
    }

    public boolean providerSelectByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.providerChangeMethodParameterToMap(MethodTypeEnum.EXAMPLE, method, topLevelClass, introspectedTable);
        return true;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        String tableName = StringUtility.escapeStringForJava((String)introspectedTable.getFullyQualifiedTableNameAtRuntime());
        DynamicTableNamePlugin.mapperReplaceAnnotationLine(introspectedTable, method, Pair.of((Object)String.format("from %s", tableName), (Object)"from \\$\\{tableName\\}"));
        return true;
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        return true;
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        return true;
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        return true;
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        return true;
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        String tableName = StringUtility.escapeStringForJava((String)introspectedTable.getFullyQualifiedTableNameAtRuntime());
        DynamicTableNamePlugin.mapperReplaceAnnotationLine(introspectedTable, method, Pair.of((Object)String.format("update %s", tableName), (Object)"update \\$\\{tableName\\}"), Pair.of((Object)"#\\{", (Object)"#\\{record."));
        return true;
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.mapperAddTableNameParameter(method, interfaze, introspectedTable);
        String tableName = StringUtility.escapeStringForJava((String)introspectedTable.getFullyQualifiedTableNameAtRuntime());
        DynamicTableNamePlugin.mapperReplaceAnnotationLine(introspectedTable, method, Pair.of((Object)String.format("update %s", tableName), (Object)"update \\$\\{tableName\\}"), Pair.of((Object)"#\\{", (Object)"#\\{record."));
        return true;
    }

    public boolean providerUpdateByExampleSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.providerChangeMethodParameterToMap(MethodTypeEnum.EXAMPLE, method, topLevelClass, introspectedTable);
        return true;
    }

    public boolean providerUpdateByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.providerChangeMethodParameterToMap(MethodTypeEnum.EXAMPLE, method, topLevelClass, introspectedTable);
        return true;
    }

    public boolean providerUpdateByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.providerChangeMethodParameterToMap(MethodTypeEnum.EXAMPLE, method, topLevelClass, introspectedTable);
        return true;
    }

    public boolean providerUpdateByPrimaryKeySelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        DynamicTableNamePlugin.providerChangeMethodParameterToMap(MethodTypeEnum.NORMAL, method, topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (!DynamicTableNamePlugin.isConfigDynamic(introspectedTable)) {
            return true;
        }
        CommentGenerator commentGenerator = this.context.getCommentGenerator();
        Field tableNameField = new Field(DYNAMIC_TABLE_NAME_FIELD_NAME, FullyQualifiedJavaType.getStringInstance());
        tableNameField.setVisibility(JavaVisibility.PRIVATE);
        commentGenerator.addFieldComment(tableNameField, introspectedTable);
        topLevelClass.addField(tableNameField);
        return true;
    }
}

